/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.game;

import com.arisux.mdxlib.MDX;
import com.arisux.mdxlib.lib.game.ModIdentityMap;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;

public class IdentityRemapModule {
    public static final IdentityRemapModule instance = new IdentityRemapModule();

    public void onLoadMissingMapping(FMLMissingMappingsEvent event) {
        MDX.log().warn("Invalid mappings found, searching for new mappings...");
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            for (ModIdentityMap mod : MDX.getRemappedMods()) {
                if (!mapping.name.contains(mod.getInvalidIdentity())) continue;
                try {
                    if (Class.forName(mod.getClassLocation()) == null) continue;
                    MDX.replaceMapping(mapping, mod.getInvalidIdentity() + ":", mod.getValidIdentity() + ":");
                }
                catch (ClassNotFoundException e) {
                    MDX.log().warn("Invalid mappings were detected, but the mod targetted for the new mappings is not present: " + mod.getClassLocation());
                }
            }
            for (ModIdentityMap.IdentityMap newMapping : MDX.getRemappedIdentities()) {
                if (!mapping.name.contains(newMapping.getInvalidIdentity())) continue;
                try {
                    if (Class.forName(newMapping.getModIdentityMap().getClassLocation()) == null) continue;
                    MDX.replaceMapping(mapping, newMapping.getInvalidIdentity(), newMapping.getValidIdentity());
                }
                catch (ClassNotFoundException e) {
                    MDX.log().warn("Invalid mappings were detected, but the mod targetted for the new mappings is not present: " + newMapping.getModIdentityMap().getClassLocation());
                }
            }
        }
    }
}

