/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.util;

import com.arisux.mdxlib.lib.client.render.OpenGL;
import com.arisux.mdxlib.lib.util.OperatingSystem;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class SystemInfo {
    public static int bytesUnit = 1024;
    public static Enumeration<NetworkInterface> networkAdapters;
    private static String processorName;
    private static long memoryCapacity;
    private static OperatingSystem osType;

    public void runtimeTasks() {
        osType = OperatingSystem.getCurrentPlatform();
        try {
            String line;
            BufferedReader buffer;
            Runtime runtime = Runtime.getRuntime();
            Process process = null;
            switch (osType) {
                case WINDOWS: {
                    process = runtime.exec("wmic cpu get name");
                    break;
                }
                case LINUX: {
                    process = runtime.exec("cat /proc/cpuinfo | grep \ufffdmodel name\ufffd");
                    break;
                }
                case OSX: {
                    process = runtime.exec("sysctl -n machdep.cpu.brand_string");
                    break;
                }
                default: {
                    process = runtime.exec("wmic cpu get name");
                }
            }
            if (process != null) {
                process.waitFor();
                buffer = new BufferedReader(new InputStreamReader(process.getInputStream()));
                line = "";
                while ((line = buffer.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    processorName = line.trim();
                }
                buffer.close();
            }
            switch (osType) {
                default: 
            }
            process = runtime.exec("wmic memorychip get capacity");
            if (process != null) {
                process.waitFor();
                buffer = new BufferedReader(new InputStreamReader(process.getInputStream()));
                line = "";
                while ((line = buffer.readLine()) != null) {
                    if (line.isEmpty() || !StringUtils.isNumeric((CharSequence)(line = StringUtils.deleteWhitespace((String)line)))) continue;
                    memoryCapacity += Long.parseLong(line);
                }
                buffer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Enumeration<NetworkInterface> networkAdapters() {
        try {
            return networkAdapters == null ? (networkAdapters = NetworkInterface.getNetworkInterfaces()) : networkAdapters;
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public static long getMemoryCapacity() {
        return memoryCapacity;
    }

    public static String gpu() {
        return OpenGL.getString(7937);
    }

    public static String gpuVendor() {
        return OpenGL.getString(7936);
    }

    public static String cpu() {
        return processorName;
    }

    public static int cpuCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static String javaVersion() {
        return SystemUtils.JAVA_VERSION;
    }

    public static OperatingSystem getOsType() {
        return osType;
    }

    public static String osName() {
        return System.getProperty("os.name");
    }

    public static String osVersion() {
        return System.getProperty("os.version");
    }

    public static String osArchitecture() {
        return System.getProperty("os.arch");
    }

    public static long vmMemoryTotalBytes() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long vmMemoryMaxBytes() {
        return Runtime.getRuntime().maxMemory();
    }

    public static long vmMemoryFreeBytes() {
        return Runtime.getRuntime().freeMemory();
    }

    public static double toTBFromB(long b) {
        return b / (long)bytesUnit / (long)bytesUnit / (long)bytesUnit / (long)bytesUnit;
    }

    public static double toGBFromB(long b) {
        return b / (long)bytesUnit / (long)bytesUnit / (long)bytesUnit;
    }

    public static double toMBFromB(long b) {
        return b / (long)bytesUnit / (long)bytesUnit;
    }

    public static double toKBFromB(long b) {
        return b / (long)bytesUnit;
    }

    public static double toTBFromMB(long mb) {
        return mb / (long)bytesUnit / (long)bytesUnit;
    }

    public static double toGBFromMB(long mb) {
        return mb / (long)bytesUnit;
    }

    public static double toKBFromMB(long mb) {
        return mb * (long)bytesUnit;
    }

    public static double toBFromMB(long mb) {
        return mb * (long)bytesUnit * (long)bytesUnit;
    }

    public static double toTBFromGB(long gb) {
        return gb / (long)bytesUnit;
    }

    public static double toMBFromGB(long gb) {
        return gb * (long)bytesUnit;
    }

    public static double toKBFromGB(long gb) {
        return gb * (long)bytesUnit * (long)bytesUnit;
    }

    public static double toBFromGB(long gb) {
        return gb * (long)bytesUnit * (long)bytesUnit * (long)bytesUnit;
    }
}

