/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.world.block;

import com.arisux.mdxlib.MDX;
import com.arisux.mdxlib.lib.world.Pos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Blocks {
    public static ArrayList<Pos> getCoordDataInRange(int posX, int posY, int posZ, int range) {
        ArrayList<Pos> data = new ArrayList<Pos>();
        for (int x = posX - range; x < posX + range * 2; ++x) {
            for (int y = posY - range; y < posY + range * 2; ++y) {
                for (int z = posZ - range; z < posZ + range * 2; ++z) {
                    data.add(new Pos(x, y, z));
                }
            }
        }
        return data;
    }

    public static ArrayList<Pos> getCoordDataInRangeIncluding(int posX, int posY, int posZ, int range, World world, Block ... types) {
        ArrayList<Pos> data = new ArrayList<Pos>();
        for (int x = posX - range; x < posX + range * 2; ++x) {
            for (int y = posY - range; y < posY + range * 2; ++y) {
                for (int z = posZ - range; z < posZ + range * 2; ++z) {
                    Pos coordData = new Pos(x, y, z);
                    Block block = coordData.getBlock(world);
                    if (!Arrays.asList(types).contains(block)) continue;
                    data.add(coordData);
                }
            }
        }
        return data;
    }

    public static ArrayList<Pos> getCoordDataInRangeExcluding(int posX, int posY, int posZ, int range, World world, Block ... types) {
        ArrayList<Pos> data = new ArrayList<Pos>();
        for (int x = posX - range; x < posX + range * 2; ++x) {
            for (int y = posY - range; y < posY + range * 2; ++y) {
                for (int z = posZ - range; z < posZ + range * 2; ++z) {
                    Pos coordData = new Pos(x, y, z);
                    Block block = coordData.getBlock(world);
                    if (Arrays.asList(types).contains(block)) continue;
                    data.add(coordData);
                }
            }
        }
        return data;
    }

    public static String getDomain(Block block) {
        String domain = "minecraft:";
        if (block.func_149739_a().contains(":")) {
            domain = (block.func_149739_a().split(":")[0] + ":").replace("tile.", "");
        }
        return domain;
    }

    public static void setCreativeTab(Block block, CreativeTabs tab) {
        if (tab != null) {
            block.func_149647_a(tab);
        }
    }

    public static float getBlockResistance(Block blockParent) {
        return MDX.access().getBlockResistance(blockParent);
    }

    public static float getBlockHardness(Block blockParent) {
        return MDX.access().getBlockResistance(blockParent);
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getBlockTexture(Block block, int side) {
        IIcon icon = block.func_149733_h(side);
        return new ResourceLocation(Blocks.getDomain(block).replace(":", ""), "textures/blocks/" + icon.func_94215_i().replace(Blocks.getDomain(block), "") + ".png");
    }
}

