/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.world.storage;

import com.arisux.mdxlib.lib.game.Access;
import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketBuffer;

public class NBTStorage {
    public static NBTTagList newStringNBTList(ArrayList<String> list) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int j = 0; j < list.size(); ++j) {
            String s1 = list.get(j);
            nbttaglist.func_74742_a((NBTBase)new NBTTagString(s1));
        }
        return nbttaglist;
    }

    public static NBTTagList newCompoundNBTList(ArrayList<NBTTagCompound> list) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int j = 0; j < list.size(); ++j) {
            NBTTagCompound nbt = list.get(j);
            nbttaglist.func_74742_a((NBTBase)nbt);
        }
        return nbttaglist;
    }

    public static void write(NBTTagCompound nbt, File file) {
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)nbt, (File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static NBTTagCompound read(File file) {
        NBTTagCompound nbtTagCompound = null;
        try {
            nbtTagCompound = CompressedStreamTools.func_74797_a((File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nbtTagCompound;
    }

    public static void writeCompressed(NBTTagCompound nbt, File file) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)stream);
        if (stream != null) {
            stream.close();
        }
    }

    public static NBTTagCompound readCompressed(File file) throws IOException {
        NBTTagCompound nbtTagCompound = null;
        FileInputStream stream = new FileInputStream(file);
        nbtTagCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
        if (stream != null) {
            stream.close();
        }
        return nbtTagCompound;
    }

    public static void writeToBuffer(NBTBase nbt, ByteBuf to) {
        PacketBuffer buffer = new PacketBuffer(to);
        try {
            NBTStorage.writeToPacketBuffer(nbt, buffer);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void writeToPacketBuffer(NBTBase nbt, PacketBuffer buffer) throws IOException {
        if (nbt == null) {
            buffer.writeShort(-1);
        } else {
            byte[] abyte = NBTStorage.toBytes(nbt);
            buffer.writeShort((int)((short)abyte.length));
            buffer.writeBytes(abyte);
        }
    }

    public static byte[] toBytes(NBTBase base) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        try (DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(bytearrayoutputstream));){
            Access.writeTag(base, dataoutputstream);
        }
        return bytearrayoutputstream.toByteArray();
    }

    public static NBTBase readFromBuffer(ByteBuf from) {
        PacketBuffer buffer = new PacketBuffer(from);
        try {
            return NBTStorage.readFromPacketBuffer(buffer);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static NBTBase readFromPacketBuffer(PacketBuffer buffer) throws IOException {
        short short1 = buffer.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        buffer.readBytes(abyte);
        return NBTStorage.fromBytes(abyte, new NBTSizeTracker(0x200000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTBase fromBytes(byte[] bytes, NBTSizeTracker tracker) throws IOException {
        NBTBase nbt;
        try (DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(bytes))));){
            nbt = Access.readTag(datainputstream, 0, tracker);
        }
        return nbt;
    }
}

