/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib;

import com.arisux.mdxlib.Console;
import com.arisux.mdxlib.MDX;
import com.arisux.mdxlib.Settings;
import com.arisux.mdxlib.lib.client.GUIElementTracker;
import com.arisux.mdxlib.lib.client.Notification;
import com.arisux.mdxlib.lib.client.NotifierModule;
import com.arisux.mdxlib.lib.game.Game;
import com.arisux.mdxlib.lib.game.IdentityRemapModule;
import com.arisux.mdxlib.lib.util.Remote;
import com.arisux.mdxlib.lib.util.SystemInfo;
import com.arisux.mdxlib.lib.world.StructureGenerationHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;

@Mod(modid="mdxlib", version="1.0.0.70")
public class MDXModule {
    private static MDX instance = new MDX();
    public static boolean enable = true;
    private final SystemInfo systemInfo = new SystemInfo();

    public static MDX instance() {
        return instance;
    }

    @Mod.EventHandler
    public void pre(FMLPreInitializationEvent event) {
        this.enable();
        if (!enable) {
            return;
        }
        this.systemInfo.runtimeTasks();
        Console.preInit();
        Settings.instance.pre(event);
        Game.registerEventHandler(StructureGenerationHandler.instance);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            Game.registerEventHandler(NotifierModule.instance);
            Game.registerEventHandler(GUIElementTracker.instance);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (!enable) {
            return;
        }
        Console.copyright();
        Console.init();
    }

    @Mod.EventHandler
    public void post(FMLPostInitializationEvent event) {
        if (!enable) {
            return;
        }
        Console.postInit();
        Console.postInitComplete();
        if (Settings.instance.isStartupNotificationEnabled()) {
            MDX.sendNotification(new Notification(){

                @Override
                public String getMessage() {
                    return "Notifications may pop up here throughout gameplay. These notifications will explain how certain features of the game work. You can disable these notifications in the settings.";
                }
            });
            Settings.instance.disableStartupNotification();
        }
    }

    @Mod.EventHandler
    public void onLoadMissingMapping(FMLMissingMappingsEvent event) {
        if (!enable) {
            return;
        }
        IdentityRemapModule.instance.onLoadMissingMapping(event);
    }

    private void enable() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && Remote.authorized()) {
            enable = false;
        }
    }
}

