/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client.render;

import com.arisux.mdxlib.lib.client.Model;
import com.arisux.mdxlib.lib.client.PlayerResourceStorage;
import com.arisux.mdxlib.lib.client.TexturedModel;
import com.arisux.mdxlib.lib.client.render.OpenGL;
import com.arisux.mdxlib.lib.client.render.Texture;
import com.arisux.mdxlib.lib.game.Game;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public abstract class ItemRenderer
implements IItemRenderer {
    protected Minecraft mc = Game.minecraft();
    private TexturedModel<? extends Model> modelTexMap;
    protected PlayerResourceStorage resourceStorage = new PlayerResourceStorage();
    private boolean rendersInFirstPerson;
    private boolean rendersInThirdPerson;
    private boolean rendersInInventory;
    private boolean rendersInWorld;

    public ItemRenderer(TexturedModel<? extends Model> modelTexMap) {
        this.modelTexMap = modelTexMap;
        this.rendersInFirstPerson = true;
        this.rendersInThirdPerson = true;
        this.rendersInInventory = true;
        this.rendersInWorld = true;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case EQUIPPED: {
                return this.rendersInThirdPerson;
            }
            case EQUIPPED_FIRST_PERSON: {
                return this.rendersInFirstPerson;
            }
            case INVENTORY: {
                return this.rendersInInventory;
            }
            case ENTITY: {
                return this.rendersInWorld;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        try {
            switch (type) {
                case EQUIPPED: {
                    OpenGL.pushMatrix();
                    OpenGL.enableBlend();
                    OpenGL.blendClear();
                    OpenGL.enableCullFace();
                    this.renderThirdPerson(item, data);
                    OpenGL.enableCullFace();
                    OpenGL.blendClear();
                    OpenGL.disableBlend();
                    OpenGL.popMatrix();
                    break;
                }
                case EQUIPPED_FIRST_PERSON: {
                    OpenGL.pushMatrix();
                    OpenGL.enableBlend();
                    OpenGL.blendClear();
                    OpenGL.enableCullFace();
                    this.renderFirstPerson(item, data);
                    OpenGL.enableCullFace();
                    OpenGL.blendClear();
                    OpenGL.disableBlend();
                    OpenGL.popMatrix();
                    break;
                }
                case INVENTORY: {
                    OpenGL.pushMatrix();
                    RenderHelper.func_74520_c();
                    OpenGL.rotate(-45.0f, 1.0f, 0.0f, 0.0f);
                    OpenGL.rotate(180.0f, 0.0f, 1.0f, 0.0f);
                    OpenGL.translate(-16.0f, 0.0f, 0.0f);
                    OpenGL.enableBlend();
                    OpenGL.blendClear();
                    OpenGL.enableCullFace();
                    this.renderInInventory(item, data);
                    OpenGL.enableCullFace();
                    OpenGL.blendClear();
                    OpenGL.disableBlend();
                    OpenGL.popMatrix();
                    break;
                }
                case ENTITY: {
                    OpenGL.pushMatrix();
                    OpenGL.enableBlend();
                    OpenGL.blendClear();
                    OpenGL.enableCullFace();
                    this.renderInWorld(item, data);
                    OpenGL.enableCullFace();
                    OpenGL.blendClear();
                    OpenGL.disableBlend();
                    OpenGL.popMatrix();
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void renderThirdPerson(ItemStack item, Object ... data) {
    }

    public void renderFirstPerson(ItemStack item, Object ... data) {
    }

    public void renderInInventory(ItemStack item, Object ... data) {
    }

    public void renderInWorld(ItemStack item, Object ... data) {
    }

    public ItemRenderer setRendersInThirdPerson(boolean rendersInThirdPerson) {
        this.rendersInThirdPerson = rendersInThirdPerson;
        return this;
    }

    public ItemRenderer setRendersInFirstPerson(boolean rendersInFirstPerson) {
        this.rendersInFirstPerson = rendersInFirstPerson;
        return this;
    }

    public ItemRenderer setRendersInInventory(boolean rendersInInventory) {
        this.rendersInInventory = rendersInInventory;
        return this;
    }

    public ItemRenderer setRendersInWorld(boolean rendersInWorld) {
        this.rendersInWorld = rendersInWorld;
        return this;
    }

    public TexturedModel<? extends Model> getModelTexMap() {
        return this.modelTexMap;
    }

    public Model getModel() {
        return this.getModelTexMap().getModel();
    }

    public Texture getTexture() {
        return this.getModelTexMap().getTexture();
    }

    public boolean firstPersonRenderCheck(Object o) {
        return o == this.mc.field_71451_h && this.mc.field_71474_y.field_74320_O == 0 && !(this.mc.field_71462_r instanceof GuiInventory) && !(this.mc.field_71462_r instanceof GuiContainerCreative);
    }
}

