/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client.render.wavefront;

import com.arisux.mdxlib.lib.client.render.Color;
import com.arisux.mdxlib.lib.client.render.Draw;
import com.arisux.mdxlib.lib.client.render.OpenGL;
import com.arisux.mdxlib.lib.client.render.wavefront.Face;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class FaceGroup {
    public String material;
    public ResourceLocation resource;
    public ArrayList<Face> faces = new ArrayList();
    public boolean listReady = false;
    public int glList;
    public Color color;

    public void bindTexture() {
        if (this.resource != null) {
            Draw.bindTexture(this.resource);
        }
    }

    public void draw() {
        if (this.resource != null) {
            this.bindTexture();
            this.drawNoBind();
        } else {
            OpenGL.disableTexture2d();
            this.drawNoBind();
            OpenGL.enableTexture2d();
        }
    }

    public void drawNoBind() {
        if (!this.listReady) {
            this.listReady = true;
            this.glList = GL11.glGenLists((int)1);
            OpenGL.newList(this.glList, 4864);
            this.drawVertex();
            OpenGL.endList();
        }
        OpenGL.callList(this.glList);
    }

    private void drawVertex() {
        int mode = 0;
        for (Face f : this.faces) {
            if (f.vertexNbr != mode) {
                if (mode != 0) {
                    GL11.glEnd();
                }
                switch (f.vertexNbr) {
                    case 3: {
                        OpenGL.begin(4);
                        break;
                    }
                    case 4: {
                        OpenGL.begin(7);
                        break;
                    }
                    case 6: {
                        OpenGL.begin(5);
                        break;
                    }
                    case 8: {
                        OpenGL.begin(5);
                    }
                }
                mode = f.vertexNbr;
            }
            if (this.color != null) {
                OpenGL.color(this.color.r, this.color.g, this.color.b);
            }
            OpenGL.normal(f.normal.x, f.normal.y, f.normal.z);
            for (int idx = 0; idx < mode; ++idx) {
                if (f.uv[idx] != null) {
                    OpenGL.texCoord(f.uv[idx].u, f.uv[idx].v);
                }
                OpenGL.vertex(f.vertex[idx].x, f.vertex[idx].y, f.vertex[idx].z);
            }
        }
        if (mode != 0) {
            OpenGL.end();
        }
    }
}

