/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client.render.wavefront;

import com.arisux.mdxlib.lib.client.render.OpenGL;
import com.arisux.mdxlib.lib.client.render.UV;
import com.arisux.mdxlib.lib.client.render.Vertex;
import com.arisux.mdxlib.lib.client.render.wavefront.FaceGroup;
import java.util.ArrayList;
import java.util.Hashtable;

public class Part {
    public ArrayList<FaceGroup> groups = new ArrayList();
    public Hashtable<String, Float> floats = new Hashtable();
    private ArrayList<Vertex> vertices;
    private ArrayList<UV> uv;
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;
    private float oX;
    private float oY;
    private float oZ;
    private float oX2;
    private float oY2;
    private float oZ2;

    public void addVertex(Vertex v) {
        this.vertices.add(v);
        this.minX = Math.min(this.minX, (double)v.x);
        this.minY = Math.min(this.minY, (double)v.y);
        this.minZ = Math.min(this.minZ, (double)v.z);
        this.maxX = Math.max(this.maxX, (double)v.x);
        this.maxY = Math.max(this.maxY, (double)v.y);
        this.maxZ = Math.max(this.maxZ, (double)v.z);
    }

    public Part(ArrayList<Vertex> vertex, ArrayList<UV> uv) {
        this.vertices = vertex;
        this.uv = uv;
    }

    public float getFloat(String name) {
        return this.floats.get(name).floatValue();
    }

    public void draw(float angle, float x, float y, float z) {
        OpenGL.pushMatrix();
        OpenGL.translate(this.oX, this.oY, this.oZ);
        OpenGL.rotate(angle, x, y, z);
        OpenGL.translate(-this.oX, -this.oY, -this.oZ);
        this.draw();
        OpenGL.popMatrix();
    }

    public void draw(float angle, float x, float y, float z, float angle2, float x2, float y2, float z2) {
        OpenGL.pushMatrix();
        OpenGL.translate(this.oX, this.oY, this.oZ);
        OpenGL.rotate(angle, x, y, z);
        OpenGL.translate(this.oX2, this.oY2, this.oZ2);
        OpenGL.rotate(angle2, x2, y2, z2);
        OpenGL.translate(-this.oX2, -this.oY2, -this.oZ2);
        OpenGL.translate(-this.oX, -this.oY, -this.oZ);
        this.draw();
        OpenGL.popMatrix();
    }

    public void drawNoBind(float angle, float x, float y, float z) {
        OpenGL.pushMatrix();
        OpenGL.translate(this.oX, this.oY, this.oZ);
        OpenGL.rotate(angle, x, y, z);
        OpenGL.translate(-this.oX, -this.oY, -this.oZ);
        this.drawNoBind();
        OpenGL.popMatrix();
    }

    public void drawNoBind() {
        for (FaceGroup fg : this.groups) {
            fg.drawNoBind();
        }
    }

    public void draw() {
        for (FaceGroup fg : this.groups) {
            fg.draw();
        }
    }

    public ArrayList<UV> getUV() {
        return this.uv;
    }

    public ArrayList<FaceGroup> getFaceGroup() {
        return this.groups;
    }

    public Hashtable<String, Float> getNameToFloatHash() {
        return this.floats;
    }

    public ArrayList<Vertex> getVertices() {
        return this.vertices;
    }

    public void setOriginX(float ox) {
        this.oX = ox;
    }

    public float getOriginX() {
        return this.oX;
    }

    public void setOriginX2(float ox2) {
        this.oX2 = ox2;
    }

    public float getOriginX2() {
        return this.oX2;
    }

    public void setOriginY(float oy) {
        this.oY = oy;
    }

    public float getOriginY() {
        return this.oY;
    }

    public void setOriginY2(float oy2) {
        this.oY2 = oy2;
    }

    public float getOriginY2() {
        return this.oY2;
    }

    public void setOriginZ(float oz) {
        this.oZ = oz;
    }

    public float getOriginZ() {
        return this.oZ;
    }

    public void setOriginZ2(float oz2) {
        this.oZ2 = oz2;
    }

    public float getOriginZ2() {
        return this.oZ2;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxZ(double maxZ) {
        this.maxZ = maxZ;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinZ(double minZ) {
        this.minZ = minZ;
    }

    public double getMinZ() {
        return this.minZ;
    }
}

