/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.util;

import com.arisux.mdxlib.MDX;
import cpw.mods.fml.common.FMLLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;

public class Jars {
    private static void copyFileFromJar(Class<?> modClass, String filePath, File to) throws IOException {
        MDX.log().info(String.format("Extracting %s from %s jar", filePath, modClass.getSimpleName()));
        URL url = modClass.getResource(filePath);
        FileUtils.copyURLToFile((URL)url, (File)to);
    }

    public static ArrayList<JarEntry> getZipEntriesInJar(JarFile jar) {
        return Collections.list(jar.entries());
    }

    public static FileInputStream getFileInputStreamFromJar(JarFile jar, File pathToFile) {
        try {
            ZipEntry zipEntry = jar.getEntry(pathToFile.toString());
            if (zipEntry != null) {
                return (FileInputStream)jar.getInputStream(zipEntry);
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.WARN, (Throwable)e, (String)"Jar %s failed to read properly, it will be ignored", (Object[])new Object[]{jar.getName()});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File extract(File compressedFile, File extractionDir) {
        if (!extractionDir.exists()) {
            extractionDir.mkdir();
        }
        ZipFile zip = null;
        zip = new ZipFile(compressedFile);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            int b;
            ZipEntry entry = e.nextElement();
            File destinationPath = new File(extractionDir, entry.getName());
            if (!destinationPath.exists()) {
                destinationPath.getParentFile().mkdirs();
            }
            if (entry.isDirectory()) continue;
            BufferedInputStream inputStream = new BufferedInputStream(zip.getInputStream(entry));
            byte[] buffer = new byte[1024];
            FileOutputStream fileOutputStream = new FileOutputStream(destinationPath);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 1024);
            while ((b = inputStream.read(buffer, 0, 1024)) != -1) {
                bufferedOutputStream.write(buffer, 0, b);
            }
            bufferedOutputStream.close();
            inputStream.close();
            MDX.log().info("Extracted: " + destinationPath);
        }
        if (zip == null) return extractionDir;
        try {
            zip.close();
            return extractionDir;
        }
        catch (Exception e2) {
            MDX.log().warn(String.format("Error closing compressed file: %s", e2));
            e2.printStackTrace();
        }
        return extractionDir;
        catch (Exception e3) {
            try {
                MDX.log().warn(String.format("Error extracting %s: %s", compressedFile.getAbsolutePath(), e3));
                e3.printStackTrace();
                if (zip == null) return extractionDir;
            }
            catch (Throwable throwable) {
                if (zip == null) throw throwable;
                try {
                    zip.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    MDX.log().warn(String.format("Error closing compressed file: %s", e2));
                    e2.printStackTrace();
                }
                throw throwable;
            }
            try {
                zip.close();
                return extractionDir;
            }
            catch (Exception e4) {
                MDX.log().warn(String.format("Error closing compressed file: %s", e4));
                e4.printStackTrace();
            }
            return extractionDir;
        }
    }
}

