/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.world;

import com.arisux.mdxlib.lib.world.CoordSelectionIterator;
import com.arisux.mdxlib.lib.world.Pos;
import java.util.Iterator;
import net.minecraft.util.AxisAlignedBB;

public class CoordSelection
implements Iterable<Pos> {
    private Pos pos1;
    private Pos pos2;

    public CoordSelection(Pos pos1, Pos pos2) {
        this.pos1 = pos1;
        this.pos2 = pos2;
    }

    public static CoordSelection areaFromSize(Pos coord, int[] size) {
        if (size[0] <= 0 || size[1] <= 0 || size[2] <= 0) {
            throw new IllegalArgumentException();
        }
        return new CoordSelection(coord, new Pos(coord.x + (double)size[0] - 1.0, coord.y + (double)size[1] - 1.0, coord.z + (double)size[2] - 1.0));
    }

    public Pos getPos1() {
        return this.pos1;
    }

    public void setPos1(Pos point1) {
        this.pos1 = point1;
    }

    public Pos getPos2() {
        return this.pos2;
    }

    public void setPos2(Pos point2) {
        this.pos2 = point2;
    }

    public Pos min() {
        return this.pos1.min(this.pos2);
    }

    public Pos max() {
        return this.pos1.max(this.pos2);
    }

    public double[] areaSize() {
        return new double[]{this.max().subtract((Pos)this.min()).x + 1.0, this.max().subtract((Pos)this.min()).y + 1.0, this.max().subtract((Pos)this.min()).z + 1.0};
    }

    public boolean contains(Pos coord) {
        return coord.x >= this.min().x && coord.y >= this.min().y && coord.z >= this.min().z && coord.x <= this.max().x && coord.y <= this.max().y && coord.z <= this.max().z;
    }

    public AxisAlignedBB asAxisAlignedBB() {
        return AxisAlignedBB.func_72330_a((double)this.min().x, (double)this.min().y, (double)this.min().z, (double)this.max().x, (double)this.max().y, (double)this.max().z);
    }

    @Override
    public Iterator<Pos> iterator() {
        return new CoordSelectionIterator(this.min(), this.max());
    }
}

