/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.world;

import com.arisux.mdxlib.lib.world.Pos;
import com.arisux.mdxlib.lib.world.storage.Schematic;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public abstract class Structure {
    private Schematic schematic;
    private WorldServer world;
    private Pos data;
    private ArrayList<Pos> blockQueue;

    public Structure(Schematic schematic, WorldServer world, Pos data) {
        this.schematic = schematic;
        this.world = world;
        this.data = data;
        this.blockQueue = new ArrayList();
        this.queueBlocks();
    }

    public Schematic getSchematic() {
        return this.schematic;
    }

    public WorldServer getWorld() {
        return this.world;
    }

    public Pos getData() {
        return this.data;
    }

    public ArrayList<Pos> getBlockQueue() {
        return this.blockQueue;
    }

    public void queueBlocks() {
        this.schematic.addBlocksToQueue(this);
    }

    public boolean process() {
        this.onProcessing();
        if (this.world.func_72912_H().func_76073_f() % 80L == 0L) {
            System.out.println("Generating " + this.getName() + ": " + this.blockQueue.size() + " blocks left in queue.");
        }
        try {
            int sectionSize = 10;
            int queueSize = this.blockQueue.size();
            if (queueSize < sectionSize) {
                sectionSize = queueSize;
            }
            for (int i = 0; i < sectionSize; ++i) {
                Pos coord = this.blockQueue.get(this.blockQueue.size() - 1 - i);
                if (coord.getBlock((World)this.world) != Blocks.field_150350_a) {
                    this.world.func_147465_d((int)coord.x, (int)coord.y, (int)coord.z, coord.getBlock((World)this.world), coord.getBlockMetadata((World)this.world), 2);
                }
                this.blockQueue.remove(coord);
            }
            if (this.blockQueue.size() <= 0) {
                this.onProcessingComplete();
                System.out.println("Generation of " + this.getName() + " completed.");
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onProcessingComplete();
            System.out.println("Generation of " + this.getName() + " completed with an error: " + e);
            return true;
        }
        return false;
    }

    public abstract String getName();

    public abstract void onProcessing();

    public abstract void onProcessingComplete();
}

