/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.world.entity;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class ItemDrop {
    private ItemStack[] itemstacks;
    private int rate;
    private DropType dropType;

    public ItemDrop(int rate, ItemStack stack) {
        this(rate, DropType.RATE_PERDROP_MULTIPLE, stack);
    }

    public ItemDrop(int rate, ItemStack ... stacks) {
        this(rate, DropType.RATE_PERDROP_MULTIPLE, stacks);
    }

    public ItemDrop(int rate, DropType dropType, ItemStack ... stacks) {
        this.itemstacks = stacks;
        this.dropType = dropType;
        this.rate = rate;
    }

    public boolean tryDrop(Entity entity) {
        return this.tryDrop(entity, this.rate, this.dropType);
    }

    public boolean tryDrop(Entity entity, int rate) {
        return this.tryDrop(entity, rate, this.dropType);
    }

    public boolean tryDrop(Entity entity, DropType type) {
        return this.tryDrop(entity, this.rate, type);
    }

    public boolean tryDrop(Entity entity, int rate, DropType type) {
        if (!entity.field_70170_p.field_72995_K) {
            Random rand = new Random();
            switch (type) {
                case RATE_PERDROP_MULTIPLE: {
                    if (rand.nextInt(100 / (rate == 0 ? this.rate : rate)) == 0) {
                        for (ItemStack stack : this.itemstacks) {
                            entity.func_70099_a(stack.func_77946_l(), 0.0f);
                        }
                        return true;
                    }
                }
                case RATE_PERDROP_SINGLE: {
                    if (rand.nextInt(100 / (rate == 0 ? this.rate : rate)) == 0) {
                        entity.func_70099_a(this.itemstacks[rand.nextInt(this.itemstacks.length)].func_77946_l(), 0.0f);
                        return true;
                    }
                }
                case RATE_PERSTACK_MULTIPLE: {
                    for (ItemStack stack : this.itemstacks) {
                        if (rand.nextInt(100 / (rate == 0 ? this.rate : rate)) != 0) continue;
                        entity.func_70099_a(stack.func_77946_l(), 0.0f);
                    }
                    return true;
                }
                case RATE_PERSTACK_SINGLE: {
                    for (ItemStack stack : this.itemstacks) {
                        if (rand.nextInt(100 / (rate == 0 ? this.rate : rate)) != 0) continue;
                        entity.func_70099_a(stack.func_77946_l(), 0.0f);
                        return true;
                    }
                    break;
                }
            }
        }
        return false;
    }

    public ItemStack[] getItemstacks() {
        return this.itemstacks;
    }

    public int getRate() {
        return this.rate;
    }

    public DropType getDropType() {
        return this.dropType;
    }

    public static enum DropType {
        RATE_PERDROP_MULTIPLE(0),
        RATE_PERDROP_SINGLE(1),
        RATE_PERSTACK_MULTIPLE(2),
        RATE_PERSTACK_SINGLE(3);

        private int id;

        private DropType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

