/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.world.storage;

import com.arisux.mdxlib.MDX;
import com.arisux.mdxlib.lib.world.CoordSelection;
import com.arisux.mdxlib.lib.world.Pos;
import com.arisux.mdxlib.lib.world.Structure;
import com.arisux.mdxlib.lib.world.tile.TileEntities;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Schematic {
    private short width;
    private short height;
    private short length;
    private Pos origin;
    private Block[] blocks;
    private byte[] metadata;
    private ArrayList<NBTTagCompound> tileEntityTags = new ArrayList();
    private Map<Short, String> idMap;
    private File file;

    public Schematic(File file, NBTTagCompound tagCompound) {
        String materials = tagCompound.func_74779_i("Materials");
        if (!materials.equals("Alpha")) {
            MDX.log().warn("Unsupported schematic format: " + file);
            return;
        }
        this.file = file;
        this.origin = new Pos(tagCompound.func_74765_d("WEOriginX"), tagCompound.func_74765_d("WEOriginY"), tagCompound.func_74765_d("WEOriginZ"));
        this.width = tagCompound.func_74765_d("Width");
        this.height = tagCompound.func_74765_d("Height");
        this.length = tagCompound.func_74765_d("Length");
        this.metadata = tagCompound.func_74770_j("Data");
        byte[] blockIds = tagCompound.func_74770_j("Blocks");
        byte[] addBlocks = tagCompound.func_74770_j("AddBlocks");
        NBTTagCompound mappings = tagCompound.func_74775_l("Mapping");
        HashMap<Short, String> idMap = new HashMap<Short, String>();
        for (Object obj : mappings.func_150296_c()) {
            String alias = obj.toString();
            short id = mappings.func_74765_d(alias);
            idMap.put(id, alias);
        }
        if (!idMap.isEmpty()) {
            System.out.println("Schematic is missing mappings: " + file);
        }
        this.idMap = idMap;
        this.blocks = new Block[blockIds.length];
        for (int i = 0; i < blockIds.length; ++i) {
            int blockID = blockIds[i] & 0xFF;
            if (addBlocks.length >= (blockIds.length + 1) / 2) {
                boolean lowerNybble = (i & 1) == 0;
                blockID |= lowerNybble ? (addBlocks[i >> 1] & 0xF) << 8 : (addBlocks[i >> 1] & 0xF0) << 4;
            }
            String key = this.idMap.get((short)blockID);
            Block block = null;
            block = key != null ? Block.func_149684_b((String)key) : null;
            this.blocks[i] = block = block == null ? Block.func_149729_e((int)blockID) : block;
        }
        NBTTagList tileEntities = tagCompound.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tileEntities.func_74745_c(); ++i) {
            this.tileEntityTags.add(tileEntities.func_150305_b(i));
        }
    }

    public void addBlocksToQueue(Structure structure) {
        CoordSelection blockArea = CoordSelection.areaFromSize(new Pos(0, 0, 0), new int[]{this.width, this.height, this.length});
        for (int pass = 0; pass < 2; ++pass) {
            for (Pos relative : blockArea) {
                int index = (int)relative.x + ((int)relative.y * this.length + (int)relative.z) * this.width;
                Pos data = structure.getData().add(relative);
                Block block = this.blocks[index];
                byte meta = this.metadata[index];
                data.store(new Pos.BlockDataStore(block, meta));
                if (block == null || this.getPass(block, meta) != pass || block == Blocks.field_150350_a) continue;
                structure.getBlockQueue().add(data);
            }
        }
    }

    public void generateTileEntities(World world, Pos data) {
        HashMap<Integer, TileEntity> tileEntities = new HashMap<Integer, TileEntity>();
        for (NBTTagCompound tag : this.tileEntityTags) {
            TileEntity tileEntity = TileEntity.func_145827_c((NBTTagCompound)tag);
            if (tileEntity == null) continue;
            tileEntities.put(new Pos(tileEntity).hashCode(), tileEntity);
        }
        CoordSelection blockArea = CoordSelection.areaFromSize(new Pos(0, 0, 0), new int[]{this.width, this.height, this.length});
        for (int pass = 0; pass < 2; ++pass) {
            for (Pos relative : blockArea) {
                int index = (int)relative.x + ((int)relative.y * this.length + (int)relative.z) * this.width;
                Block block = this.blocks[index];
                byte meta = this.metadata[index];
                if (block == null || this.getPass(block, meta) != pass) continue;
                Pos pos = new Pos(data.x, data.y, data.z).add(relative).store(new Pos.BlockDataStore(block, meta));
                TileEntity tileEntity = (TileEntity)tileEntities.get(relative.hashCode());
                if (tileEntity == null) continue;
                world.func_72921_c((int)pos.x, (int)pos.y, (int)pos.z, (int)meta, 2);
                TileEntities.setTileEntityPosition(tileEntity, pos);
                world.func_147455_a((int)pos.x, (int)pos.y, (int)pos.z, tileEntity);
                tileEntity.func_145836_u();
            }
        }
    }

    @Deprecated
    public void generate(World world, Pos data) {
        HashMap<Integer, TileEntity> tileEntities = new HashMap<Integer, TileEntity>();
        for (NBTTagCompound tag : this.tileEntityTags) {
            TileEntity tileEntity = TileEntity.func_145827_c((NBTTagCompound)tag);
            if (tileEntity == null) continue;
            tileEntities.put(new Pos(tileEntity).hashCode(), tileEntity);
        }
        CoordSelection blockArea = CoordSelection.areaFromSize(new Pos(0, 0, 0), new int[]{this.width, this.height, this.length});
        for (int pass = 0; pass < 2; ++pass) {
            for (Pos relative : blockArea) {
                int index = (int)relative.x + ((int)relative.y * this.length + (int)relative.z) * this.width;
                Block block = this.blocks[index];
                byte meta = this.metadata[index];
                if (block == null || this.getPass(block, meta) != pass) continue;
                Pos pos = new Pos(data.x, data.y, data.z).add(relative).store(new Pos.BlockDataStore(block, meta));
                world.func_147465_d((int)pos.x, (int)pos.y, (int)pos.z, block, (int)meta, 3);
                TileEntity tileEntity = (TileEntity)tileEntities.get(relative.hashCode());
                if (tileEntity == null) continue;
                world.func_72921_c((int)pos.x, (int)pos.y, (int)pos.z, (int)meta, 2);
                TileEntities.setTileEntityPosition(tileEntity, pos);
                world.func_147455_a((int)pos.x, (int)pos.y, (int)pos.z, tileEntity);
                tileEntity.func_145836_u();
            }
        }
    }

    private int getPass(Block block, int metadata) {
        return block.func_149721_r() || block.func_149688_o() == Material.field_151579_a ? 0 : 1;
    }

    public File getFile() {
        return this.file;
    }

    public short width() {
        return this.width;
    }

    public short height() {
        return this.height;
    }

    public short length() {
        return this.length;
    }

    public Block[] blocks() {
        return this.blocks;
    }

    public byte[] metadata() {
        return this.metadata;
    }

    public Pos origin() {
        return this.origin;
    }

    public ArrayList<NBTTagCompound> getTileEntities() {
        return this.tileEntityTags;
    }
}

