/*
 * Decompiled with CFR 0.152.
 */
package portablejim.planterhelper;

import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import portablejim.planterhelper.commands.CommandSmiteMe;
import portablejim.planterhelper.config.ConfigValues;
import portablejim.planterhelper.core.FarmlandCraftingHandler;
import portablejim.planterhelper.gui.GuiHandler;
import portablejim.planterhelper.items.AdvancedSeedPlanter;
import portablejim.planterhelper.items.BasicSeedPlanter;
import portablejim.planterhelper.items.DragonEggToken;
import portablejim.planterhelper.items.VeinSeedPlanter;
import portablejim.planterhelper.network.PacketHandler;

@Mod(modid="PlanterHelper", name="Planter Helper")
@NetworkMod(clientSideRequired=true, serverSideRequired=true, channels={"PlanterHelper"}, packetHandler=PacketHandler.class)
public class PlanterHelper {
    public static final String MODID = "PlanterHelper";
    public static final String NAME = "Planter Helper";
    @Mod.Instance(value="PlanterHelper")
    public static PlanterHelper instance;
    public ConfigValues configValues;
    public static BasicSeedPlanter basicPlanter;
    public static AdvancedSeedPlanter advancedPlanter;
    public static VeinSeedPlanter veinPlanter;
    public static DragonEggToken eggToken;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configValues = new ConfigValues(event.getSuggestedConfigurationFile());
        this.configValues.loadConfigFile();
        eggToken = new DragonEggToken(this.configValues.ITEMIDS_EGG_TOKEN);
        basicPlanter = new BasicSeedPlanter(this.configValues.ITEMIDS_BASIC_PLANTER);
        advancedPlanter = new AdvancedSeedPlanter(this.configValues.ITEMIDS_ADVANCED_PLANTER);
        veinPlanter = new VeinSeedPlanter(this.configValues.ITEMIDS_VEIN_PLANTER);
        GameRegistry.registerItem((Item)eggToken, (String)"PlanterHelper:dragonEggToken");
        GameRegistry.registerItem((Item)basicPlanter, (String)"PlanterHelper:basicPlanter");
        GameRegistry.registerItem((Item)advancedPlanter, (String)"PlanterHelper:advancedPlanter");
        GameRegistry.registerItem((Item)veinPlanter, (String)"PlanterHelper:veinPlanter");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ItemStack hoeStack = new ItemStack(Item.field_77689_P);
        ItemStack dispenserStack = new ItemStack(Block.field_71958_P);
        ItemStack basicPlanterStack = new ItemStack((Item)basicPlanter);
        ItemStack hopperStack = new ItemStack((Block)Block.field_94340_cs);
        ItemStack diamondStack = new ItemStack(Item.field_77702_n);
        ItemStack blazeRodStack = new ItemStack(Item.field_77731_bo);
        ItemStack pumpkinStack = new ItemStack(Block.field_72061_ba);
        ItemStack wheatStack = new ItemStack(Item.field_77685_T);
        ItemStack carrotStack = new ItemStack(Item.field_82797_bK);
        ItemStack potatoStack = new ItemStack(Item.field_82794_bL);
        ItemStack netherStarStack = new ItemStack(Item.field_82792_bS);
        ItemStack dragonEggStack = new ItemStack(Block.field_72084_bK);
        ItemStack chestStack = new ItemStack((Block)Block.field_72077_au);
        ItemStack clockStack = new ItemStack(Item.field_77752_aS);
        new GuiHandler();
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)basicPlanter), (Object[])new Object[]{"wcp", " d ", " h ", Character.valueOf('w'), wheatStack, Character.valueOf('c'), carrotStack, Character.valueOf('p'), potatoStack, Character.valueOf('d'), dispenserStack, Character.valueOf('h'), hoeStack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)basicPlanter), (Object[])new Object[]{"wpc", " d ", " h ", Character.valueOf('w'), wheatStack, Character.valueOf('c'), carrotStack, Character.valueOf('p'), potatoStack, Character.valueOf('d'), dispenserStack, Character.valueOf('h'), hoeStack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)basicPlanter), (Object[])new Object[]{"cwp", " d ", " h ", Character.valueOf('w'), wheatStack, Character.valueOf('c'), carrotStack, Character.valueOf('p'), potatoStack, Character.valueOf('d'), dispenserStack, Character.valueOf('h'), hoeStack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)advancedPlanter), (Object[])new Object[]{"dhp", " b ", " r ", Character.valueOf('d'), diamondStack, Character.valueOf('h'), hopperStack, Character.valueOf('p'), pumpkinStack, Character.valueOf('b'), basicPlanterStack, Character.valueOf('r'), blazeRodStack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)veinPlanter), (Object[])new Object[]{" n ", "dal", " h ", Character.valueOf('n'), netherStarStack, Character.valueOf('d'), dragonEggStack, Character.valueOf('a'), advancedPlanter, Character.valueOf('l'), clockStack, Character.valueOf('h'), chestStack});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Block.field_72084_bK), (Object[])new Object[]{eggToken});
        GameRegistry.registerCraftingHandler((ICraftingHandler)new FarmlandCraftingHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (Item item : Item.field_77698_e) {
            if (item == null || !(item instanceof ItemHoe)) continue;
            OreDictionary.registerOre((String)"hoe", (ItemStack)new ItemStack(item, 1, Short.MAX_VALUE));
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Block.field_72050_aA), new Object[]{Block.field_71979_v, "hoe"}));
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        ServerCommandManager scm = (ServerCommandManager)MinecraftServer.func_71276_C().func_71187_D();
        scm.func_71560_a((ICommand)new CommandSmiteMe());
    }

    @ForgeSubscribe
    public void lightningStrike(EntityStruckByLightningEvent event) {
        int HOTBAR_SIZE = 9;
        Entity entity = event.entity;
        HashSet<String> easterEggUsers = new HashSet<String>();
        easterEggUsers.add("portablejim");
        easterEggUsers.add("straymaverick");
        if (entity instanceof EntityPlayer && (easterEggUsers.contains(((EntityPlayer)entity).field_71092_bJ.toLowerCase()) || this.configValues.EASTER_EGG_SHARE)) {
            EntityPlayer player = (EntityPlayer)entity;
            for (int i = 0; i < 9; ++i) {
                ItemStack item = player.field_71071_by.func_70301_a(i);
                if (item == null || !(item.func_77973_b() instanceof VeinSeedPlanter) || item.func_77960_j() != 0) continue;
                item.func_77964_b(1);
            }
        }
    }
}

