/*
 * Decompiled with CFR 0.152.
 */
package portablejim.planterhelper.core;

import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class PlantingLogic {
    public static int getSeedsSlot(IInventory inv, int initialSlot) {
        if (initialSlot < 0) {
            return -1;
        }
        ItemStack initialTarget = inv.func_70301_a(initialSlot);
        if (initialTarget != null && initialTarget.field_77994_a > 0) {
            return initialSlot;
        }
        int slot = 0;
        while (inv.func_70301_a(slot) == null || inv.func_70301_a(slot).func_77973_b() == null || !(inv.func_70301_a(slot).func_77973_b() instanceof IPlantable) || inv.func_70301_a((int)slot).field_77994_a <= 0 && slot < inv.func_70302_i_()) {
            if (++slot < inv.func_70302_i_()) continue;
            return -1;
        }
        return slot;
    }

    public static boolean placeSeed(IInventory inv, World world, int x, int y, int z, int invPos, ForgeDirection direction) {
        ItemStack currentItem = inv.func_70301_a(invPos);
        if (currentItem == null || !(currentItem.func_77973_b() instanceof IPlantable)) {
            return false;
        }
        IPlantable plantable = (IPlantable)currentItem.func_77973_b();
        int blockId = world.func_72798_a(x, y, z);
        if (blockId > Block.field_71973_m.length - 1) {
            return false;
        }
        if (Block.field_71973_m[blockId] == null || !Block.field_71973_m[blockId].canSustainPlant(world, x, y, z, direction, plantable)) {
            return false;
        }
        if (!world.func_72799_c(x, y + 1, z)) {
            return false;
        }
        int plantId = plantable.getPlantID(world, x, y + 1, z);
        int plantMeta = plantable.getPlantMetadata(world, x, y + 1, z);
        world.func_72832_d(x, y + 1, z, plantId, plantMeta, 3);
        return true;
    }

    public static boolean targetedSuitableFarmland(World world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        int blockId = world.func_72798_a(x, y, z);
        if (blockId > Block.field_71973_m.length - 1) {
            return false;
        }
        if (Block.field_71973_m[blockId] == null) {
            return false;
        }
        return Block.field_71973_m[blockId].canSustainPlant(world, x, y, z, direction, plantable);
    }
}

