/*
 * Decompiled with CFR 0.152.
 */
package portablejim.planterhelper.items;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import portablejim.planterhelper.PlanterHelper;
import portablejim.planterhelper.core.PlantingLogic;
import portablejim.planterhelper.gui.SeedInventory;

public abstract class Planter
extends Item {
    protected boolean hasGui;
    protected int invSlots;
    protected int range;

    public Planter(int guiSlots, int range) {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
        if (guiSlots > 0) {
            this.hasGui = true;
            this.invSlots = guiSlots;
        } else {
            this.hasGui = false;
            this.invSlots = -1;
        }
        this.range = range;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (this.hasGui && par3EntityPlayer.func_70093_af()) {
            par3EntityPlayer.openGui((Object)PlanterHelper.instance, 0, par2World, 0, 0, 0);
        }
        return par1ItemStack;
    }

    public boolean func_77648_a(ItemStack itemStackUsed, EntityPlayer player, World world, int x, int y, int z, int intDirection, float par8, float par9, float par10) {
        if (this.hasGui && player.func_70093_af()) {
            return false;
        }
        IInventory inventory = this.getInventory(player);
        if (inventory == null) {
            return false;
        }
        if (this.canPlant(inventory, world, x, y, z, ForgeDirection.getOrientation((int)intDirection))) {
            this.plant(player, inventory, world, x, y, z, this.range, player.field_70177_z);
        }
        return true;
    }

    public int func_77626_a(ItemStack itemstack) {
        return 1;
    }

    public IInventory getInventory(EntityPlayer player) {
        if (player.func_70694_bm().func_77973_b() == this) {
            return new SeedInventory(player.func_70694_bm());
        }
        return null;
    }

    public int getFirstSlot(IInventory inventory) {
        return 0;
    }

    public boolean canPlant(IInventory inv, World world, int x, int y, int z, ForgeDirection direction) {
        int nextSlot = PlantingLogic.getSeedsSlot(inv, this.getFirstSlot(inv));
        if (nextSlot >= 0) {
            ItemStack targetItem = inv.func_70301_a(nextSlot);
            assert (targetItem != null);
            assert (targetItem.func_77973_b() instanceof IPlantable);
            IPlantable targetPlantable = (IPlantable)targetItem.func_77973_b();
            return PlantingLogic.targetedSuitableFarmland(world, x, y, z, direction, targetPlantable);
        }
        return false;
    }

    public void plant(EntityPlayer player, IInventory inv, World world, int startX, int startY, int startZ, int width, float playerRotation) {
        int intFacing = MathHelper.func_76128_c((double)((double)(playerRotation * 4.0f / 360.0f) + 0.5)) & 3;
        ForgeDirection[] directions = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.EAST};
        ForgeDirection direction = directions[intFacing];
        switch (direction) {
            case NORTH: {
                int startCornerZ;
                int startCornerX = startX - (width - 1) / 2;
                for (int rowZ = startCornerZ = startZ; rowZ > startCornerZ - width; --rowZ) {
                    for (int columnX = startCornerX; columnX < startCornerX + width; ++columnX) {
                        this.plantSeedInPlace(inv, world, columnX, startY, rowZ, direction);
                    }
                }
                break;
            }
            case EAST: {
                int startCornerX = startX;
                int startCornerZ = startZ - (width - 1) / 2;
                for (int rowX = startCornerX; rowX < startCornerX + width; ++rowX) {
                    for (int columnZ = startCornerZ; columnZ < startCornerZ + width; ++columnZ) {
                        this.plantSeedInPlace(inv, world, rowX, startY, columnZ, direction);
                    }
                }
                break;
            }
            case SOUTH: {
                int startCornerZ;
                int startCornerX = startX + (width - 1) / 2;
                for (int rowZ = startCornerZ = startZ; rowZ < startCornerZ + width; ++rowZ) {
                    for (int columnX = startCornerX; columnX > startCornerX - width; --columnX) {
                        this.plantSeedInPlace(inv, world, columnX, startY, rowZ, direction);
                    }
                }
                break;
            }
            case WEST: {
                int startCornerX = startX;
                int startCornerZ = startZ + (width - 1) / 2;
                for (int rowX = startCornerX; rowX > startCornerX - width; --rowX) {
                    for (int columnZ = startCornerZ; columnZ > startCornerZ - width; --columnZ) {
                        this.plantSeedInPlace(inv, world, rowX, startY, columnZ, direction);
                    }
                }
                break;
            }
        }
    }

    public boolean plantSeedInPlace(IInventory inv, World world, int x, int y, int z, ForgeDirection direction) {
        int slot = PlantingLogic.getSeedsSlot(inv, this.getFirstSlot(inv));
        if (slot < 0) {
            return false;
        }
        boolean success = PlantingLogic.placeSeed(inv, world, x, y, z, slot, direction);
        if (success) {
            inv.func_70298_a(slot, 1);
        }
        return success;
    }

    public int getInvSlots() {
        return this.invSlots;
    }
}

