/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.config;

import codechicken.core.colour.Colour;
import codechicken.core.colour.ColourRGBA;
import codechicken.core.config.ConfigFile;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigTag {
    private static final Pattern patternRGB = Pattern.compile("(\\d+),(\\d+),(\\d+)");
    public ConfigFile parentfile;
    public ConfigTag parenttag;
    public TreeMap childtags = new TreeMap();
    public String name;
    public String qualifiedname;
    public String comment;
    public String value;
    public boolean brace;
    public boolean newline;
    public int sortMode;
    public int position = Integer.MAX_VALUE;
    private int IDBase;

    public ConfigTag(ConfigTag parent, String name) {
        this.parenttag = parent;
        this.parentfile = parent.parentfile;
        this.name = name;
        this.qualifiedname = String.valueOf(parent.qualifiedname) + "." + name;
        parent.childtags.put(name, this);
    }

    public ConfigTag(ConfigFile parent, String name) {
        this.parentfile = parent;
        this.name = name;
        this.qualifiedname = name;
        this.parentfile.maintags.put(name, this);
        this.newline = parent.newlinemode == 2;
    }

    public ConfigTag getTag(String tagname, boolean createnew) {
        int dotpos = (tagname = tagname.replace('_', ' ')).indexOf(".");
        String maintagname = dotpos == -1 ? tagname : tagname.substring(0, dotpos);
        ConfigTag basetag = (ConfigTag)this.childtags.get(maintagname);
        if (basetag == null) {
            if (!createnew) {
                return null;
            }
            basetag = this.getNewTag(maintagname);
            this.parentfile.saveConfig();
        }
        if (dotpos == -1) {
            return basetag;
        }
        return basetag.getTag(tagname.substring(dotpos + 1));
    }

    public ConfigTag getTag(String tagname) {
        return this.getTag(tagname, true);
    }

    public ConfigTag getNewTag(String name) {
        return new ConfigTag(this, name);
    }

    public boolean tagExists(String tagname) {
        return this.getTag(tagname, false) != null;
    }

    public boolean deleteTag(String tagname) {
        String lastpart;
        ConfigTag tag = this.getTag(tagname, false);
        if (tag == null) {
            return false;
        }
        int dotpos = tagname.lastIndexOf(".");
        String string = lastpart = dotpos == -1 ? tagname : tagname.substring(dotpos + 1, tagname.length());
        if (tag.parenttag != null) {
            return tag.parenttag.childtags.remove(lastpart) != null;
        }
        if (tag.parentfile != null) {
            return tag.parentfile.maintags.remove(lastpart) != null;
        }
        return false;
    }

    public void setValue(String value) {
        this.value = value;
        this.parentfile.saveConfig();
    }

    public void setDefaultValue(String defaultvalue) {
        if (this.value == null) {
            this.value = defaultvalue;
            this.parentfile.saveConfig();
        }
    }

    public void setIntValue(int i) {
        this.setValue(Integer.toString(i));
    }

    public void setBooleanValue(boolean b) {
        this.setValue(Boolean.toString(b));
    }

    public void setHexValue(int i) {
        this.setValue("0x" + Long.toString((long)i << 32 >>> 32, 16));
    }

    public void setColourRGB(Colour c) {
        String s = Long.toString((long)c.rgb() << 32 >>> 32, 16);
        while (s.length() < 6) {
            s = "0" + s;
        }
        this.setValue("0x" + s.toUpperCase());
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(String defaultvalue) {
        this.setDefaultValue(defaultvalue);
        return this.value;
    }

    public int getIntValue() {
        return Integer.parseInt(this.getValue());
    }

    public int getIntValue(int defaultvalue) {
        if (this.value == null) {
            this.setIntValue(defaultvalue);
        }
        try {
            return this.getIntValue();
        }
        catch (NumberFormatException nfe) {
            this.setIntValue(defaultvalue);
            return this.getIntValue();
        }
    }

    public boolean getBooleanValue() {
        String value = this.getValue();
        if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"))) {
            return true;
        }
        if (value != null && (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no"))) {
            return false;
        }
        throw new NumberFormatException(String.valueOf(this.qualifiedname) + ".value=" + value);
    }

    public boolean getBooleanValue(boolean defaultvalue) {
        if (this.value == null) {
            this.setBooleanValue(defaultvalue);
        }
        try {
            return this.getBooleanValue();
        }
        catch (NumberFormatException nfe) {
            this.setBooleanValue(defaultvalue);
            return this.getBooleanValue();
        }
    }

    public int getHexValue() {
        return (int)Long.parseLong(this.getValue().replace("0x", ""), 16);
    }

    public int getHexValue(int defaultvalue) {
        if (this.value == null) {
            this.setHexValue(defaultvalue);
        }
        try {
            return this.getHexValue();
        }
        catch (NumberFormatException nfe) {
            this.setHexValue(defaultvalue);
            return this.getHexValue();
        }
    }

    public Colour getColourRGB() {
        Matcher matcherRGB = patternRGB.matcher(this.getValue().replaceAll("\\s", ""));
        if (matcherRGB.matches()) {
            return new ColourRGBA(Integer.parseInt(matcherRGB.group(1)), Integer.parseInt(matcherRGB.group(2)), Integer.parseInt(matcherRGB.group(3)), 255);
        }
        return new ColourRGBA(this.getHexValue() << 8 | 0xFF);
    }

    public Colour getColourRGB(Colour defaultvalue) {
        if (this.value == null) {
            this.setColourRGB(defaultvalue);
        }
        try {
            return this.getColourRGB();
        }
        catch (NumberFormatException nfe) {
            this.setColourRGB(defaultvalue);
            return this.getColourRGB();
        }
    }

    public void save(PrintWriter writer, int tabs, String bracequalifier) {
        String unqualifiedname = this.qualifiedname;
        unqualifiedname = unqualifiedname.replace(' ', '_');
        if (this.qualifiedname.contains(".") && !bracequalifier.equals("")) {
            unqualifiedname = this.qualifiedname.substring(bracequalifier.length() + 1).replace(' ', '_');
        }
        if (this.newline) {
            ConfigFile.writeLine(writer, "", tabs);
        }
        if (this.comment != null && !this.comment.equals("")) {
            String doubledelimcomment = this.comment.replace("::", "~|~");
            String[] comments = doubledelimcomment.split(":");
            int i = 0;
            while (i < comments.length) {
                comments[i] = comments[i].replace("~|~", ":");
                ConfigFile.writeLine(writer, "#" + comments[i], tabs);
                ++i;
            }
        }
        if (this.value != null) {
            ConfigFile.writeLine(writer, String.valueOf(unqualifiedname) + "=" + this.value, tabs);
        }
        if (this.brace && this.childtags.size() > 0) {
            ConfigFile.writeLine(writer, unqualifiedname, tabs);
            ConfigFile.writeLine(writer, "{", tabs);
            ConfigFile.saveTagTree(writer, this.childtags, tabs + 1, this.qualifiedname.replace(' ', '_'), this.sortMode);
            ConfigFile.writeLine(writer, "}", tabs);
        } else if (this.childtags.size() > 0) {
            ConfigFile.saveTagTree(writer, this.childtags, tabs, bracequalifier, this.sortMode);
        }
    }

    public ConfigTag setNewLine(boolean b) {
        this.newline = b;
        this.parentfile.saveConfig();
        return this;
    }

    public ConfigTag useBraces() {
        this.brace = true;
        if (this.parenttag == null && this.parentfile.newlinemode == 1) {
            this.newline = true;
        }
        this.parentfile.saveConfig();
        return this;
    }

    public ConfigTag setSortMode(int mode) {
        this.sortMode = mode;
        this.parentfile.saveConfig();
        return this;
    }

    public ConfigTag setComment(String string) {
        this.comment = string;
        this.parentfile.saveConfig();
        return this;
    }

    public ConfigTag setPosition(int pos) {
        this.position = pos;
        this.parentfile.saveConfig();
        return this;
    }

    public void loadChildren(BufferedReader reader) {
        String comment = "";
        String bracequalifier = "";
        try {
            String line;
            while ((line = ConfigFile.readLine(reader)) != null) {
                if (line.startsWith("#")) {
                    if (comment == null || comment.equals("")) {
                        comment = line.substring(1);
                        continue;
                    }
                    comment = String.valueOf(comment) + ":" + line.substring(1);
                    continue;
                }
                if (line.contains("=")) {
                    String qualifiedname = line.substring(0, line.indexOf("="));
                    this.getTag(qualifiedname).setComment(comment).setValue(line.substring(line.indexOf("=") + 1));
                    comment = "";
                    bracequalifier = qualifiedname;
                    continue;
                }
                if (line.equals("{")) {
                    this.getTag(bracequalifier).setComment(comment).useBraces().loadChildren(reader);
                    comment = "";
                    bracequalifier = "";
                    continue;
                }
                if (line.equals("}")) {
                    return;
                }
                bracequalifier = line;
            }
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Code Chicken Core", true);
        }
    }

    public boolean containsTag(String tagname) {
        return this.getTag(tagname, false) != null;
    }

    public int getBlockId(String name, int defaultValue) {
        return this.getTag(name).getIntValue(defaultValue);
    }

    public int getBlockId(String name) {
        int ret = this.getBlockId(name, this.IDBase);
        this.IDBase = ret + 1;
        return ret;
    }

    public int getItemId(String name, int defaultValue) {
        return this.getTag(name).getIntValue(defaultValue);
    }

    public int getItemId(String name) {
        int ret = this.getItemId(name, this.IDBase);
        this.IDBase = ret + 1;
        return ret;
    }

    public int getAcheivementId(String name, int defaultValue) {
        return this.getTag(name).getIntValue(defaultValue);
    }

    public ConfigTag setBaseID(int i) {
        this.IDBase = i;
        return this;
    }
}

