/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.render.PlaceholderTexture;
import codechicken.core.render.TextureSpecial;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.util.Dimension;

public class TextureUtils {
    private static HashMap textureDimensions;
    private static ArrayList iconRegistrars;

    static {
        bgz.a.q.put(null, new RegisterTextureCallback());
        textureDimensions = new HashMap();
        iconRegistrars = new ArrayList();
    }

    public static void addIconRegistrar(IIconRegister registrar) {
        iconRegistrars.add(registrar);
    }

    public static bip createTextureObject(String textureFile) {
        BufferedImage img = TextureUtils.loadBufferedImage(textureFile);
        return new bip(textureFile, 2, img.getWidth(), img.getHeight(), 10496, 6408, 9728, 9728, img);
    }

    public static InputStream getTextureResource(String textureFile) throws IOException {
        return TextureUtils.engine().g.e().a(textureFile);
    }

    public static BufferedImage loadBufferedImage(String textureFile) {
        try {
            InputStream in = TextureUtils.getTextureResource(textureFile);
            if (in != null) {
                BufferedImage img = TextureUtils.loadBufferedImage(in);
                if (img != null) {
                    textureDimensions.put(textureFile, new Dimension(img.getWidth(), img.getHeight()));
                }
                return img;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load texture file: " + textureFile);
            e.printStackTrace();
        }
        textureDimensions.put(textureFile, new Dimension(0, 0));
        return null;
    }

    public static Dimension getTextureDimension(String textureFile) {
        Dimension dim = (Dimension)textureDimensions.get(textureFile);
        if (dim == null) {
            TextureUtils.loadBufferedImage(textureFile);
            dim = (Dimension)textureDimensions.get(textureFile);
        }
        return dim;
    }

    public static BufferedImage loadBufferedImage(InputStream in) throws IOException {
        BufferedImage img = ImageIO.read(in);
        in.close();
        return img;
    }

    public static bgf engine() {
        return Minecraft.x().p;
    }

    public static bip createTextureObject(String name, int w, int h) {
        return new bip(name, 2, w, h, 10496, 6408, 9728, 9728, null);
    }

    public static void copySubImg(bip fromTex, int fromX, int fromY, int width, int height, bip toTex, int toX, int toY) {
        int fromWidth = fromTex.d();
        int toWidth = toTex.d();
        ByteBuffer from = fromTex.h();
        ByteBuffer to = toTex.h();
        from.position(0);
        to.position(0);
        int y2 = 0;
        while (y2 < height) {
            int x = 0;
            while (x < width) {
                int fp = ((y2 + fromY) * fromWidth + x + fromX) * 4;
                int tp2 = ((y2 + toY) * toWidth + x + toX) * 4;
                to.put(tp2, from.get(fp));
                to.put(tp2 + 1, from.get(fp + 1));
                to.put(tp2 + 2, from.get(fp + 2));
                to.put(tp2 + 3, from.get(fp + 3));
                ++x;
            }
            ++y2;
        }
        toTex.a(new bgd(0, 0, 0, 0), 0);
    }

    public static void write(byte[] data, int width, int height, bip toTex, int toX, int toY) {
        int toWidth = toTex.d();
        ByteBuffer to = toTex.h();
        to.position(0);
        int y2 = 0;
        while (y2 < height) {
            int x = 0;
            while (x < width) {
                int fp = (y2 * width + x) * 4;
                int tp2 = ((y2 + toY) * toWidth + x + toX) * 4;
                to.put(tp2, data[fp]);
                to.put(tp2 + 1, data[fp + 1]);
                to.put(tp2 + 2, data[fp + 2]);
                to.put(tp2 + 3, data[fp + 3]);
                ++x;
            }
            ++y2;
        }
        toTex.a(new bgd(0, 0, 0, 0), 0);
        to.position(toWidth * toTex.e() * 4);
    }

    public static boolean refreshTexture(bis map, String name) {
        if (map.getTextureExtry(name) == null) {
            map.setTextureEntry(name, (bim)new PlaceholderTexture(name));
            return true;
        }
        return false;
    }

    public static void bindItemTexture(wm stack) {
        TextureUtils.engine().b(stack.d() == 0 ? "/terrain.png" : "/gui/items.png");
    }

    public static void bindTexture(String string) {
        TextureUtils.engine().b(string);
    }

    public static lx getIconFromTexture(String name, ly iconRegister, boolean animated) {
        bis textureMap = (bis)iconRegister;
        TextureSpecial icon = new TextureSpecial(name).setTextureFile(name).useVanillaAnimation(animated);
        textureMap.setTextureEntry(name, (bim)icon);
        return icon;
    }

    public static lx getIconFromTexture(String name, ly iconRegister) {
        return TextureUtils.getIconFromTexture(name, iconRegister, true);
    }

    public static interface IIconRegister {
        public void registerIcons(ly var1);
    }

    private static class RegisterTextureCallback
    extends bha {
        private RegisterTextureCallback() {
        }

        public void a(mp entity, double d0, double d1, double d2, float f, float f1) {
        }

        public void a(ly par1IconRegister) {
            for (IIconRegister r : iconRegistrars) {
                r.registerIcons(par1IconRegister);
            }
        }
    }
}

