/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.CodeChickenCorePlugin;
import codechicken.core.asm.DependancyLister;
import cpw.mods.fml.relauncher.IClassTransformer;
import cpw.mods.fml.relauncher.RelaunchClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class DelegatedTransformer
implements IClassTransformer {
    private static ArrayList delegatedTransformers;
    private static Method m_defineClass;
    private static Field f_cachedClasses;

    public DelegatedTransformer() {
        delegatedTransformers = new ArrayList();
        try {
            m_defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            m_defineClass.setAccessible(true);
            f_cachedClasses = RelaunchClassLoader.class.getDeclaredField("cachedClasses");
            f_cachedClasses.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] transform(String name, String tname, byte[] bytes) {
        for (IClassTransformer trans : delegatedTransformers) {
            bytes = trans.transform(name, tname, bytes);
        }
        return bytes;
    }

    public static void addTransformer(String transformer, JarFile jar, File jarFile) {
        try {
            IClassTransformer classTransformer;
            byte[] bytes = null;
            bytes = CodeChickenCorePlugin.cl.getClassBytes(transformer);
            if (bytes == null) {
                String resourceName = String.valueOf(transformer.replace('.', '/')) + ".class";
                ZipEntry entry = jar.getEntry(resourceName);
                if (entry == null) {
                    throw new Exception("Failed to add transformer: " + transformer + ". Entry not found in jar file " + jarFile.getName());
                }
                bytes = DelegatedTransformer.readFully(jar.getInputStream(entry));
            }
            DelegatedTransformer.defineDependancies(bytes, jar, jarFile);
            Class clazz = DelegatedTransformer.defineClass(transformer, bytes);
            if (!IClassTransformer.class.isAssignableFrom(clazz)) {
                throw new Exception("Failed to add transformer: " + transformer + " is not an instance of IClassTransformer");
            }
            try {
                classTransformer = (IClassTransformer)clazz.getDeclaredConstructor(File.class).newInstance(jarFile);
            }
            catch (NoSuchMethodException nsme) {
                classTransformer = (IClassTransformer)clazz.newInstance();
            }
            delegatedTransformers.add(classTransformer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void defineDependancies(byte[] bytes, JarFile jar, File jarFile) throws Exception {
        DelegatedTransformer.defineDependancies(bytes, jar, jarFile, new Stack());
    }

    private static void defineDependancies(byte[] bytes, JarFile jar, File jarFile, Stack depStack) throws Exception {
        ClassReader reader = new ClassReader(bytes);
        DependancyLister lister = new DependancyLister(262144);
        reader.accept((ClassVisitor)lister, 0);
        depStack.push(reader.getClassName());
        for (String dependancy : lister.getDependancies()) {
            if (depStack.contains(dependancy)) continue;
            try {
                CodeChickenCorePlugin.cl.loadClass(dependancy.replace('/', '.'));
            }
            catch (ClassNotFoundException cnfe) {
                ZipEntry entry = jar.getEntry(String.valueOf(dependancy) + ".class");
                if (entry == null) {
                    throw new Exception("Dependancy " + dependancy + " not found in jar file " + jarFile.getName());
                }
                byte[] depbytes = DelegatedTransformer.readFully(jar.getInputStream(entry));
                DelegatedTransformer.defineDependancies(depbytes, jar, jarFile, depStack);
                System.out.println("Defining dependancy: " + dependancy);
                DelegatedTransformer.defineClass(dependancy.replace('/', '.'), depbytes);
            }
        }
        depStack.pop();
    }

    private static Class defineClass(String classname, byte[] bytes) throws Exception {
        Class clazz = (Class)m_defineClass.invoke((Object)CodeChickenCorePlugin.cl, classname, bytes, 0, bytes.length);
        ((Map)f_cachedClasses.get(CodeChickenCorePlugin.cl)).put(classname, clazz);
        return clazz;
    }

    public static byte[] readFully(InputStream stream) throws IOException {
        int r;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(stream.available());
        while ((r = stream.read()) != -1) {
            bos.write(r);
        }
        return bos.toByteArray();
    }
}

