/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.packet;

import codechicken.core.data.MCDataInput;
import codechicken.core.data.MCDataOutput;
import codechicken.core.vec.BlockCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.ITinyPacketHandler;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.liquids.LiquidStack;

public final class PacketCustom
implements MCDataInput,
MCDataOutput {
    private Object channel;
    private int type;
    private boolean isChunkDataPacket;
    private boolean incoming;
    private ByteArrayOutputStream dataarrayout;
    private DataOutputStream dataout;
    private DataInputStream datain;
    private static HashMap clienthandlermap = new HashMap();
    private static HashMap serverhandlermap = new HashMap();

    private PacketCustom(dk packet) {
        this.incoming = true;
        this.channel = packet.a;
        if (packet.c == null) {
            packet.c = new byte[0];
        }
        this.datain = new DataInputStream(new ByteArrayInputStream(packet.c));
        this.type = this.readUnsignedByte();
    }

    private PacketCustom(db packet) {
        this.incoming = true;
        this.channel = packet.a;
        this.datain = new DataInputStream(new ByteArrayInputStream(packet.c));
        this.type = packet.b;
    }

    public PacketCustom(Object channel, int type) {
        this.channel = channel;
        this.type = type;
        this.incoming = false;
        this.isChunkDataPacket = false;
        this.dataarrayout = new ByteArrayOutputStream();
        this.dataout = new DataOutputStream(this.dataarrayout);
        this.writeByte(type);
    }

    public int getType() {
        return this.type;
    }

    public void setChunkDataPacket() {
        this.isChunkDataPacket = true;
    }

    public ei toPacket() {
        if (this.type == 0) {
            FMLCommonHandler.instance().raiseException((Throwable)new IllegalStateException("Type not set"), "Custom Packet", true);
            return null;
        }
        if (this.incoming) {
            FMLCommonHandler.instance().raiseException((Throwable)new IllegalStateException("Tried to write an incoming packet"), "Custom Packet", true);
            return null;
        }
        if (this.channel instanceof String) {
            dk payload = new dk();
            payload.a = (String)this.channel;
            payload.s = this.isChunkDataPacket;
            payload.c = this.dataarrayout.toByteArray();
            payload.b = payload.c.length;
            return payload;
        }
        NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(this.channel);
        if (nmh == null) {
            FMLCommonHandler.instance().raiseException((Throwable)new IllegalStateException("Invalid mod object for channel: " + this.channel), "Custom Packet", true);
            return null;
        }
        byte[] data = this.dataarrayout.toByteArray();
        db payload = new db((short)nmh.getNetworkId(), (short)this.type, Arrays.copyOfRange(data, 1, data.length));
        payload.s = this.isChunkDataPacket;
        return payload;
    }

    @Override
    public void writeBoolean(boolean b) {
        try {
            this.dataout.writeBoolean(b);
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
        }
    }

    @Override
    public void writeByte(int b) {
        try {
            this.dataout.writeByte(b);
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
        }
    }

    @Override
    public void writeShort(int s) {
        try {
            this.dataout.writeShort(s);
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
        }
    }

    @Override
    public void writeInt(int i) {
        try {
            this.dataout.writeInt(i);
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
        }
    }

    @Override
    public void writeFloat(float f) {
        try {
            this.dataout.writeFloat(f);
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
        }
    }

    @Override
    public void writeDouble(double d) {
        try {
            this.dataout.writeDouble(d);
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
        }
    }

    @Override
    public void writeLong(long l) {
        try {
            this.dataout.writeLong(l);
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
        }
    }

    @Override
    public void writeChar(char c) {
        try {
            this.dataout.writeChar(c);
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
        }
    }

    @Override
    public void writeByteArray(byte[] barray) {
        try {
            this.dataout.write(barray);
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
        }
    }

    @Override
    public void writeCoord(int x, int y2, int z2) {
        this.writeInt(x);
        this.writeInt(y2);
        this.writeInt(z2);
    }

    @Override
    public void writeCoord(BlockCoord coord) {
        this.writeInt(coord.x);
        this.writeInt(coord.y);
        this.writeInt(coord.z);
    }

    @Override
    public void writeString(String s) {
        try {
            if (s.length() > 65535) {
                throw new IOException("String length: " + s.length() + "too long.");
            }
            this.dataout.writeShort(s.length());
            this.dataout.writeChars(s);
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
        }
    }

    @Override
    public void writeItemStack(wm spawnstack) {
        if (spawnstack == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(spawnstack.c);
            this.writeByte(spawnstack.a);
            this.writeShort(spawnstack.k());
            this.writeNBTTagCompound(spawnstack.d);
        }
    }

    @Override
    public void writeNBTTagCompound(bs compound) {
        try {
            if (compound == null) {
                this.writeShort(-1);
            } else {
                byte[] var3 = cc.a((bs)compound);
                this.writeShort((short)var3.length);
                this.writeByteArray(var3);
            }
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
        }
    }

    @Override
    public void writeLiquidStack(LiquidStack liquid) {
        if (liquid == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(liquid.itemID);
            this.writeInt(liquid.amount);
            this.writeShort(liquid.itemMeta);
        }
    }

    @Override
    public boolean readBoolean() {
        try {
            return this.datain.readBoolean();
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
            return false;
        }
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public byte readByte() {
        try {
            return this.datain.readByte();
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
            return 0;
        }
    }

    @Override
    public short readShort() {
        try {
            return this.datain.readShort();
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
            return 0;
        }
    }

    @Override
    public int readInt() {
        try {
            return this.datain.readInt();
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
            return 0;
        }
    }

    @Override
    public float readFloat() {
        try {
            return this.datain.readFloat();
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
            return 0.0f;
        }
    }

    @Override
    public double readDouble() {
        try {
            return this.datain.readDouble();
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
            return 0.0;
        }
    }

    @Override
    public long readLong() {
        try {
            return this.datain.readLong();
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
            return 0L;
        }
    }

    @Override
    public char readChar() {
        try {
            return this.datain.readChar();
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
            return '\u0000';
        }
    }

    @Override
    public BlockCoord readCoord() {
        return new BlockCoord(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    public byte[] readByteArray(int length) {
        try {
            byte[] barray = new byte[length];
            this.datain.readFully(barray, 0, length);
            return barray;
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
            return null;
        }
    }

    @Override
    public String readString() {
        try {
            int length = this.datain.readUnsignedShort();
            char[] chars = new char[length];
            int i = 0;
            while (i < length) {
                chars[i] = this.readChar();
                ++i;
            }
            return new String(chars);
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
            return null;
        }
    }

    @Override
    public wm readItemStack() {
        wm var2 = null;
        short itemID = this.readShort();
        if (itemID >= 0) {
            byte stackSize = this.readByte();
            short damage = this.readShort();
            var2 = new wm((int)itemID, (int)stackSize, (int)damage);
            var2.d = this.readNBTTagCompound();
        }
        return var2;
    }

    @Override
    public bs readNBTTagCompound() {
        short var2;
        block3: {
            try {
                var2 = this.readShort();
                if (var2 >= 0) break block3;
                return null;
            }
            catch (IOException e) {
                FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
                return null;
            }
        }
        byte[] var3 = this.readByteArray(var2);
        return cc.a((byte[])var3);
    }

    @Override
    public LiquidStack readLiquidStack() {
        LiquidStack var2 = null;
        short liquidID = this.readShort();
        if (liquidID >= 0) {
            int amount = this.readInt();
            short liquidMeta = this.readShort();
            var2 = new LiquidStack((int)liquidID, amount, (int)liquidMeta);
        }
        return var2;
    }

    public static void assignHandler(String channel, int firstID, int lastID, ICustomPacketHandler IHandler) {
        Side side = IHandler instanceof ICustomPacketHandler.IClientPacketHandler ? Side.CLIENT : Side.SERVER;
        HashMap handlerMap = side.isClient() ? clienthandlermap : serverhandlermap;
        CustomPacketHandler handler = (CustomPacketHandler)handlerMap.get(channel);
        if (handler == null) {
            handler = side.isClient() ? new ClientPacketHandler(channel) : new ServerPacketHandler(channel);
            handlerMap.put(channel, handler);
        }
        handler.registerRange(firstID, lastID, IHandler);
    }

    public static void assignHandler(Object mod, ICustomPacketHandler handler) {
        NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mod);
        if (nmh == null || nmh.getTinyPacketHandler() == null || !(nmh.getTinyPacketHandler() instanceof CustomTinyPacketHandler)) {
            FMLCommonHandler.instance().raiseException((Throwable)new IllegalStateException("Invalid network tiny packet handler for mod: " + mod), "Custom Packet", true);
            return;
        }
        ((CustomTinyPacketHandler)nmh.getTinyPacketHandler()).registerSidedHandler(handler);
    }

    public void sendToPlayer(jc player) {
        PacketCustom.sendToPlayer(this.toPacket(), (sq)player);
    }

    public static void sendToPlayer(ei packet, sq player) {
        ((jc)player).a.b(packet);
    }

    public void sentToClients() {
        PacketCustom.sendToClients(this.toPacket());
    }

    public static void sendToClients(ei packet) {
        MinecraftServer.D().ad().a(packet);
    }

    public void sendPacketToAllAround(double x, double y2, double z2, double range, int dim) {
        PacketCustom.sendToAllAround(this.toPacket(), x, y2, z2, range, dim);
    }

    public static void sendToAllAround(ei packet, double x, double y2, double z2, double range, int dim) {
        MinecraftServer.D().ad().a(x, y2, z2, range, dim, packet);
    }

    public void sendToDimension(int dim) {
        PacketCustom.sendToDimension(this.toPacket(), dim);
    }

    public static void sendToDimension(ei packet, int dim) {
        MinecraftServer.D().ad().a(packet, dim);
    }

    public void sendToChunk(aab world, int chunkX, int chunkZ) {
        PacketCustom.sendToChunk(this.toPacket(), world, chunkX, chunkZ);
    }

    public static void sendToChunk(ei packet, aab world, int chunkX, int chunkZ) {
        ix p = ((iz)world).r().a(chunkX, chunkZ, false);
        if (p != null) {
            p.a(packet);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendToServer() {
        PacketCustom.sendToServer(this.toPacket());
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendToServer(ei packet) {
        Minecraft.x().r().c(packet);
    }

    /* synthetic */ PacketCustom(dk dk2, PacketCustom packetCustom) {
        this(dk2);
    }

    /* synthetic */ PacketCustom(db db2, PacketCustom packetCustom) {
        this(db2);
    }

    private static class ClientPacketHandler
    extends CustomPacketHandler {
        public ClientPacketHandler(String channel) {
            super(channel);
        }

        @Override
        public Side getSide() {
            return Side.CLIENT;
        }

        @Override
        public void handle(ICustomPacketHandler handler, PacketCustom packet, Player player) {
            ((ICustomPacketHandler.IClientPacketHandler)handler).handlePacket(packet, Minecraft.x().r(), Minecraft.x());
        }
    }

    private static class ClientTinyPacketHandler {
        ICustomPacketHandler.IClientPacketHandler clientHandler;

        public ClientTinyPacketHandler(ICustomPacketHandler.IClientPacketHandler handler) {
            this.clientHandler = handler;
        }

        public void handle(PacketCustom packetCustom, ej handler) {
            this.clientHandler.handlePacket(packetCustom, (bdl)handler, Minecraft.x());
        }
    }

    private static abstract class CustomPacketHandler
    implements IPacketHandler {
        HashMap handlermap = new HashMap();

        public CustomPacketHandler(String channel) {
            NetworkRegistry.instance().registerChannel((IPacketHandler)this, channel, this.getSide());
        }

        public void onPacketData(cg manager, dk packet, Player player) {
            PacketCustom packetCustom = new PacketCustom(packet, null);
            ICustomPacketHandler handler = (ICustomPacketHandler)this.handlermap.get(packetCustom.type);
            if (handler != null) {
                this.handle(handler, packetCustom, player);
            }
        }

        public void registerRange(int firstID, int lastID, ICustomPacketHandler handler) {
            int i = firstID;
            while (i <= lastID) {
                this.handlermap.put(i, handler);
                ++i;
            }
        }

        public abstract Side getSide();

        public abstract void handle(ICustomPacketHandler var1, PacketCustom var2, Player var3);
    }

    public static final class CustomTinyPacketHandler
    implements ITinyPacketHandler {
        private ClientTinyPacketHandler clientDelegate;
        private ServerTinyPacketHandler serverDelegate;

        public void handle(ej handler, db packet) {
            PacketCustom packetCustom = new PacketCustom(packet, null);
            if (handler instanceof jh) {
                this.serverDelegate.handle(packetCustom, handler);
            } else {
                this.clientDelegate.handle(packetCustom, handler);
            }
        }

        private void registerSidedHandler(ICustomPacketHandler handler) {
            if (handler instanceof ICustomPacketHandler.IClientPacketHandler) {
                if (this.clientDelegate != null) {
                    throw new IllegalStateException("Client handler already registered");
                }
                this.clientDelegate = new ClientTinyPacketHandler((ICustomPacketHandler.IClientPacketHandler)handler);
            } else if (handler instanceof ICustomPacketHandler.IServerPacketHandler) {
                if (this.serverDelegate != null) {
                    throw new IllegalStateException("Server handler already registered");
                }
                this.serverDelegate = new ServerTinyPacketHandler((ICustomPacketHandler.IServerPacketHandler)handler);
            } else {
                throw new IllegalStateException("Handler is not a client or server handler");
            }
        }
    }

    public static interface ICustomPacketHandler {

        public static interface IClientPacketHandler
        extends ICustomPacketHandler {
            public void handlePacket(PacketCustom var1, bdl var2, Minecraft var3);
        }

        public static interface IServerPacketHandler
        extends ICustomPacketHandler {
            public void handlePacket(PacketCustom var1, jh var2, jc var3);
        }
    }

    private static class ServerPacketHandler
    extends CustomPacketHandler {
        public ServerPacketHandler(String channel) {
            super(channel);
        }

        @Override
        public Side getSide() {
            return Side.SERVER;
        }

        @Override
        public void handle(ICustomPacketHandler handler, PacketCustom packet, Player player) {
            ((ICustomPacketHandler.IServerPacketHandler)handler).handlePacket(packet, ((jc)player).a, (jc)player);
        }
    }

    private static class ServerTinyPacketHandler {
        ICustomPacketHandler.IServerPacketHandler serverHandler;

        public ServerTinyPacketHandler(ICustomPacketHandler.IServerPacketHandler handler) {
            this.serverHandler = handler;
        }

        public void handle(PacketCustom packetCustom, ej handler) {
            this.serverHandler.handlePacket(packetCustom, (jh)handler, ((jh)handler).c);
        }
    }
}

