/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.render.TextureFX;
import codechicken.core.render.TextureSpecial;
import codechicken.core.render.TextureUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.lwjgl.util.Dimension;

public class SpriteSheetManager {
    private static HashMap spriteSheets = new HashMap();

    public static SpriteSheet getSheet(String textureFile) {
        return SpriteSheetManager.getSheet(16, 16, textureFile);
    }

    public static SpriteSheet getSheet(int tilesX, int tilesY, String textureFile) {
        SpriteSheet sheet = (SpriteSheet)spriteSheets.get(textureFile);
        if (sheet == null) {
            sheet = new SpriteSheet(tilesX, tilesY, textureFile);
            spriteSheets.put(textureFile, sheet);
        }
        return sheet;
    }

    @SideOnly(value=Side.CLIENT)
    public static class SpriteSheet
    implements TextureUtils.IIconRegister {
        private int tilesX;
        private int tilesY;
        private ArrayList newSprites = new ArrayList();
        private TextureSpecial[] sprites;
        private String textureFile;
        private bip texture;
        private int spriteWidth;
        private int spriteHeight;

        private SpriteSheet(int tilesX, int tilesY, String textureFile) {
            this.tilesX = tilesX;
            this.tilesY = tilesY;
            this.textureFile = textureFile;
            this.sprites = new TextureSpecial[tilesX * tilesY];
        }

        public void requestIndicies(int ... indicies) {
            int[] nArray = indicies;
            int n = indicies.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                this.setupSprite(i);
                ++n2;
            }
        }

        @Override
        public void registerIcons(ly register) {
            bis textureMap = (bis)register;
            if (TextureUtils.refreshTexture(textureMap, this.textureFile)) {
                this.reloadTexture();
                int i = 0;
                while (i < this.sprites.length) {
                    if (this.sprites[i] != null) {
                        textureMap.setTextureEntry(this.sprites[i].i(), (bim)this.sprites[i]);
                    }
                    ++i;
                }
            } else {
                Iterator iterator = this.newSprites.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    textureMap.setTextureEntry(this.sprites[i].i(), (bim)this.sprites[i]);
                }
            }
            this.newSprites.clear();
        }

        public TextureSpecial setupSprite(int i) {
            if (this.sprites[i] == null) {
                String name = String.valueOf(this.textureFile) + "_" + i;
                this.sprites[i] = new TextureSpecial(name).baseFromSheet(this, i);
                this.newSprites.add(i);
            }
            return this.sprites[i];
        }

        private void reloadTexture() {
            this.texture = TextureUtils.createTextureObject(this.textureFile);
            Dimension dim = TextureUtils.getTextureDimension(this.textureFile);
            this.spriteWidth = dim.getWidth() / this.tilesX;
            this.spriteHeight = dim.getHeight() / this.tilesY;
        }

        public lx getSprite(int index) {
            TextureSpecial i = this.sprites[index];
            if (i == null) {
                throw new IllegalArgumentException("Sprite at index: " + index + " from texture file " + this.textureFile + " was not preloaded.");
            }
            return i;
        }

        public bip createSprite(int spriteIndex) {
            int sx = spriteIndex % this.tilesX;
            int sy = spriteIndex / this.tilesX;
            bip sprite = TextureUtils.createTextureObject(String.valueOf(this.textureFile) + "_" + spriteIndex, this.spriteWidth, this.spriteHeight);
            TextureUtils.copySubImg(this.texture, sx * this.spriteWidth, sy * this.spriteHeight, this.spriteWidth, this.spriteHeight, sprite, 0, 0);
            return sprite;
        }

        public int spriteWidth() {
            return this.spriteWidth;
        }

        public int spriteHeight() {
            return this.spriteHeight;
        }

        public TextureSpecial bindTextureFX(int i, TextureFX textureFX) {
            return this.setupSprite(i).addTextureFX(textureFX);
        }

        public void selfRegister() {
            TextureUtils.addIconRegistrar(this);
        }
    }
}

