/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.ASMHelper;
import codechicken.core.asm.CodeChickenCorePlugin;
import codechicken.core.asm.InstructionComparator;
import codechicken.core.asm.ObfuscationMappings;
import codechicken.core.config.ConfigFile;
import codechicken.core.config.ConfigTag;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.io.File;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TweakTransformer
implements IClassTransformer,
Opcodes {
    private static HashMultimap altercators = HashMultimap.create();
    public static ConfigTag tweaks;

    public static void load() {
        ConfigFile config;
        File cfgDir = new File(CodeChickenCorePlugin.minecraftDir + "/config");
        if (!cfgDir.exists()) {
            cfgDir.mkdirs();
        }
        if (!(tweaks = (config = new ConfigFile(new File(cfgDir, "CodeChickenCore.cfg")).setComment("CodeChickenCore configuration file.")).getTag("tweaks").setComment("Various tweaks that can be applied to game mechanics.").useBraces()).getTag("persistantLava").setComment("Set to false to make lava fade away like water if all the source blocks are destroyed").getBooleanValue(true)) {
            ObfuscationMappings.ClassMapping blockFlowing = new ObfuscationMappings.ClassMapping("anf");
            TweakTransformer.alterMethod(new ASMHelper.MethodAltercator(new ObfuscationMappings.DescriptorMapping(blockFlowing.s_class, new ObfuscationMappings.DescriptorMapping("apa", "a", "(Laab;IIILjava/util/Random;)V"))){

                @Override
                public void alter(MethodNode mv2) {
                    InsnList needle = new InsnList();
                    needle.add((AbstractInsnNode)new VarInsnNode(21, 6));
                    needle.add((AbstractInsnNode)new VarInsnNode(54, -1));
                    needle.add((AbstractInsnNode)new InsnNode(3));
                    needle.add((AbstractInsnNode)new VarInsnNode(54, 8));
                    List lists = InstructionComparator.insnListFindL(mv2.instructions, needle);
                    if (lists.size() != 1) {
                        throw new RuntimeException("Needle found " + lists.size() + " times in Haystack: " + mv2.instructions + "\n" + ASMHelper.printInsnList(needle));
                    }
                    InstructionComparator.InsnListSection subsection = (InstructionComparator.InsnListSection)lists.get(0);
                    AbstractInsnNode insn = subsection.first;
                    while (true) {
                        AbstractInsnNode next = insn.getNext();
                        mv2.instructions.remove(insn);
                        if (insn == subsection.last) break;
                        insn = next;
                    }
                }
            });
        }
        if (tweaks.getTag("environmentallyFriendlyCreepers").setComment("If set to true, creepers will not destroy landscape. (A version of mobGreifing setting just for creepers)").getBooleanValue(false)) {
            final ObfuscationMappings.ClassMapping entityCreeper = new ObfuscationMappings.ClassMapping("ru");
            TweakTransformer.alterMethod(new ASMHelper.MethodAltercator(new ObfuscationMappings.DescriptorMapping(entityCreeper.s_class, new ObfuscationMappings.DescriptorMapping("mp", "l_", "()V"))){

                @Override
                public void alter(MethodNode mv2) {
                    InsnList needle = new InsnList();
                    needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    needle.add((AbstractInsnNode)new ObfuscationMappings.DescriptorMapping(entityCreeper.s_class, new ObfuscationMappings.DescriptorMapping("mp", "q", "Laab;")).toFieldInsn(180));
                    needle.add((AbstractInsnNode)new MethodInsnNode(182, "aab", "M", "()Lzy;"));
                    needle.add((AbstractInsnNode)new LdcInsnNode((Object)"mobGriefing"));
                    needle.add((AbstractInsnNode)new MethodInsnNode(182, "zy", "b", "(Ljava/lang/String;)Z"));
                    List lists = InstructionComparator.insnListFindL(mv2.instructions, needle);
                    if (lists.size() != 1) {
                        throw new RuntimeException("Needle found " + lists.size() + " times in Haystack: " + mv2.instructions + "\n" + ASMHelper.printInsnList(needle));
                    }
                    InstructionComparator.InsnListSection subsection = (InstructionComparator.InsnListSection)lists.get(0);
                    mv2.instructions.insertBefore(subsection.first, (AbstractInsnNode)new InsnNode(3));
                    AbstractInsnNode insn = subsection.first;
                    while (true) {
                        AbstractInsnNode next = insn.getNext();
                        mv2.instructions.remove(insn);
                        if (insn == subsection.last) break;
                        insn = next;
                    }
                }
            });
        }
        if (!tweaks.getTag("softLeafReplace").setComment("If set to false, leaves will only replace air when growing").getBooleanValue(false)) {
            TweakTransformer.alterMethod(new ASMHelper.MethodAltercator(new ObfuscationMappings.DescriptorMapping("apa", "canBeReplacedByLeaves", "(Laab;III)Z")){

                @Override
                public void alter(MethodNode mv2) {
                    InsnList replacement = new InsnList();
                    replacement.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    replacement.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    replacement.add((AbstractInsnNode)new VarInsnNode(21, 2));
                    replacement.add((AbstractInsnNode)new VarInsnNode(21, 3));
                    replacement.add((AbstractInsnNode)new VarInsnNode(21, 4));
                    replacement.add((AbstractInsnNode)new MethodInsnNode(182, "apa", "isAirBlock", "(Laab;III)Z"));
                    replacement.add((AbstractInsnNode)new InsnNode(172));
                    mv2.instructions = replacement;
                }
            });
        }
    }

    private static void alterMethod(ASMHelper.MethodAltercator ma) {
        altercators.put((Object)ma.method.javaClass(), (Object)ma);
    }

    public byte[] transform(String name, String tname, byte[] bytes) {
        bytes = ASMHelper.alterMethods(name, bytes, altercators);
        return bytes;
    }
}

