/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.data;

import codechicken.core.data.MCDataInput;
import codechicken.core.data.MCDataOutput;
import codechicken.core.vec.BlockCoord;
import net.minecraftforge.liquids.LiquidStack;

public class NBTDataWrapper
implements MCDataInput,
MCDataOutput {
    private ca readList;
    private int readTag = 0;
    private ca writeList;

    public NBTDataWrapper(ca input) {
        this.readList = input;
    }

    public NBTDataWrapper() {
        this.writeList = new ca();
    }

    public ca toTag() {
        return this.writeList;
    }

    @Override
    public void writeLong(long l) {
        this.writeList.a((cf)new cb(null, l));
    }

    @Override
    public void writeInt(int i) {
        this.writeList.a((cf)new bz(null, i));
    }

    @Override
    public void writeShort(int s) {
        this.writeList.a((cf)new cd(null, (short)s));
    }

    @Override
    public void writeByte(int b) {
        this.writeList.a((cf)new br(null, (byte)b));
    }

    @Override
    public void writeDouble(double d) {
        this.writeList.a((cf)new bv(null, d));
    }

    @Override
    public void writeFloat(float f) {
        this.writeList.a((cf)new bx(null, f));
    }

    @Override
    public void writeBoolean(boolean b) {
        this.writeList.a((cf)new br(null, (byte)(b ? 1 : 0)));
    }

    @Override
    public void writeChar(char c) {
        this.writeList.a((cf)new cd(null, (short)c));
    }

    @Override
    public void writeByteArray(byte[] array) {
        this.writeList.a((cf)new bq(null, array));
    }

    @Override
    public void writeString(String s) {
        this.writeList.a((cf)new ce(null, s));
    }

    @Override
    public void writeCoord(int x, int y2, int z2) {
        this.writeInt(x);
        this.writeInt(y2);
        this.writeInt(z2);
    }

    @Override
    public void writeCoord(BlockCoord coord) {
        this.writeCoord(coord.x, coord.y, coord.z);
    }

    @Override
    public void writeNBTTagCompound(bs tag) {
        this.writeList.a((cf)tag);
    }

    @Override
    public void writeItemStack(wm stack) {
        this.writeList.a((cf)stack.b(new bs()));
    }

    @Override
    public void writeLiquidStack(LiquidStack liquid) {
        this.writeList.a((cf)liquid.writeToNBT(new bs()));
    }

    @Override
    public long readLong() {
        return ((cb)this.readTag()).a;
    }

    @Override
    public int readInt() {
        return ((bz)this.readTag()).a;
    }

    @Override
    public short readShort() {
        return ((cd)this.readTag()).a;
    }

    @Override
    public int readUnsignedShort() {
        return ((cd)this.readTag()).a & 0xFFFF;
    }

    @Override
    public byte readByte() {
        return ((br)this.readTag()).a;
    }

    @Override
    public int readUnsignedByte() {
        return ((br)this.readTag()).a & 0xFF;
    }

    @Override
    public double readDouble() {
        return ((bv)this.readTag()).a;
    }

    @Override
    public float readFloat() {
        return ((bx)this.readTag()).a;
    }

    @Override
    public boolean readBoolean() {
        return ((br)this.readTag()).a != 0;
    }

    @Override
    public char readChar() {
        return (char)((cd)this.readTag()).a;
    }

    @Override
    public byte[] readByteArray(int length) {
        return ((bq)this.readTag()).a;
    }

    @Override
    public String readString() {
        return ((ce)this.readTag()).a;
    }

    @Override
    public BlockCoord readCoord() {
        return new BlockCoord(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    public bs readNBTTagCompound() {
        return (bs)this.readTag();
    }

    @Override
    public wm readItemStack() {
        return wm.a((bs)this.readNBTTagCompound());
    }

    @Override
    public LiquidStack readLiquidStack() {
        return LiquidStack.loadLiquidStackFromNBT((bs)this.readNBTTagCompound());
    }

    private cf readTag() {
        return this.readList.b(this.readTag++);
    }
}

