/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import codechicken.core.inventory.ContainerExtended;
import codechicken.core.inventory.IContainerSyncVar;
import codechicken.lib.packet.PacketCustom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ContainerSynchronised
extends ContainerExtended {
    private ArrayList<IContainerSyncVar> syncVars = new ArrayList();

    public abstract PacketCustom createSyncPacket();

    public final void b() {
        super.b();
        for (int i = 0; i < this.syncVars.size(); ++i) {
            IContainerSyncVar var = this.syncVars.get(i);
            if (!var.changed()) continue;
            PacketCustom packet = this.createSyncPacket();
            packet.writeByte(i);
            var.writeChange(packet);
            this.sendContainerPacket(packet);
            var.reset();
        }
    }

    @Override
    public void sendContainerAndContentsToPlayer(uy container, List<ye> list, List<jv> playerCrafters) {
        super.sendContainerAndContentsToPlayer(container, list, playerCrafters);
        for (int i = 0; i < this.syncVars.size(); ++i) {
            IContainerSyncVar var = this.syncVars.get(i);
            PacketCustom packet = this.createSyncPacket();
            packet.writeByte(i);
            var.writeChange(packet);
            var.reset();
            for (jv player : playerCrafters) {
                packet.sendToPlayer((uf)player);
            }
        }
    }

    public void addSyncVar(IContainerSyncVar var) {
        this.syncVars.add(var);
    }

    @Override
    public final void handleOutputPacket(PacketCustom packet) {
        this.syncVars.get(packet.readUByte()).readChange(packet);
    }

    public List<IContainerSyncVar> getSyncedVars() {
        return Collections.unmodifiableList(this.syncVars);
    }
}

