/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.lib.asm.ASMHelper;
import codechicken.lib.asm.ClassHeirachyManager;
import codechicken.lib.asm.ObfMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class DefaultImplementationTransformer
implements IClassTransformer {
    private static LaunchClassLoader cl = (LaunchClassLoader)ClassHeirachyManager.class.getClassLoader();
    private static HashMap<String, InterfaceImpl> impls = new HashMap();

    private static ClassNode getClassNode(String name) {
        try {
            return ASMHelper.createClassNode((byte[])cl.getClassBytes(name.replace('/', '.')));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerDefaultImpl(String iname, String cname) {
        impls.put(iname.replace('.', '/'), new InterfaceImpl(iname, cname));
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.startsWith("net.minecraft") || impls.isEmpty()) {
            return bytes;
        }
        ClassNode cnode = ASMHelper.createClassNode((byte[])bytes);
        boolean changed = false;
        for (String iname : cnode.interfaces) {
            InterfaceImpl impl = impls.get(iname);
            if (impl == null) continue;
            changed |= impl.patch(cnode);
        }
        return changed ? ASMHelper.createBytes((ClassNode)cnode, (int)0) : bytes;
    }

    static class InterfaceImpl {
        public final String iname;
        public ArrayList<MethodNode> impls = new ArrayList();

        public InterfaceImpl(String iname, String cname) {
            this.iname = iname;
            HashSet<String> names = new HashSet<String>();
            ClassNode inode = DefaultImplementationTransformer.getClassNode(iname);
            for (MethodNode method : inode.methods) {
                names.add(method.name + method.desc);
            }
            ClassNode cnode = DefaultImplementationTransformer.getClassNode(cname);
            for (MethodNode method : cnode.methods) {
                if (!names.contains(method.name + method.desc)) continue;
                this.impls.add(method);
                method.desc = new ObfMapping((String)cnode.name, (String)method.name, (String)method.desc).toRuntime().s_desc;
            }
        }

        public boolean patch(ClassNode cnode) {
            LinkedList<String> names = new LinkedList<String>();
            for (MethodNode method : cnode.methods) {
                ObfMapping m = new ObfMapping(cnode.name, method.name, method.desc).toRuntime();
                names.add(m.s_name + m.s_desc);
            }
            boolean changed = false;
            for (MethodNode impl : this.impls) {
                if (names.contains(impl.name + impl.desc)) continue;
                MethodNode copy = new MethodNode(impl.access, impl.name, impl.desc, impl.signature, impl.exceptions == null ? null : impl.exceptions.toArray(new String[0]));
                ASMHelper.copy((MethodNode)impl, (MethodNode)copy);
                cnode.methods.add(impl);
                changed = true;
            }
            return changed;
        }
    }
}

