/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.fluid;

import codechicken.lib.inventory.InventoryUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidUtils {
    public static int B = 1000;
    public static FluidStack water = new FluidStack(FluidRegistry.WATER, 1000);
    public static FluidStack lava = new FluidStack(FluidRegistry.LAVA, 1000);

    public static boolean fillTankWithContainer(IFluidHandler tank, EntityPlayer player) {
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        if (liquid == null) {
            return false;
        }
        if (tank.fill(null, liquid, false) != liquid.amount && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        tank.fill(null, liquid, true);
        if (!player.field_71075_bZ.field_75098_d) {
            InventoryUtils.consumeItem((IInventory)player.field_71071_by, (int)player.field_71071_by.field_70461_c);
        }
        player.field_71069_bz.func_75142_b();
        return true;
    }

    public static boolean emptyTankIntoContainer(IFluidHandler tank, EntityPlayer player, FluidStack tankLiquid) {
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!FluidContainerRegistry.isEmptyContainer((ItemStack)stack)) {
            return false;
        }
        ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)tankLiquid, (ItemStack)stack);
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled);
        if (liquid == null || filled == null) {
            return false;
        }
        tank.drain(null, liquid.amount, true);
        if (!player.field_71075_bZ.field_75098_d) {
            if (stack.field_77994_a == 1) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
            } else if (player.field_71071_by.func_70441_a(filled)) {
                --stack.field_77994_a;
            } else {
                return false;
            }
        }
        player.field_71069_bz.func_75142_b();
        return true;
    }

    public static FluidStack copy(FluidStack liquid, int quantity) {
        liquid = liquid.copy();
        liquid.amount = quantity;
        return liquid;
    }

    public static FluidStack read(NBTTagCompound tag) {
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
        return stack != null ? stack : new FluidStack(new Fluid("none", null, null), 0);
    }

    public static NBTTagCompound write(FluidStack fluid, NBTTagCompound tag) {
        return fluid == null || fluid.getFluid() == null ? new NBTTagCompound() : fluid.writeToNBT(new NBTTagCompound());
    }

    public static int getLuminosity(FluidStack stack, double density) {
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return 0;
        }
        int light = fluid.getLuminosity(stack);
        if (fluid.isGaseous()) {
            light = (int)((double)light * density);
        }
        return light;
    }

    public static FluidStack emptyFluid() {
        return new FluidStack(water, 0);
    }
}

