/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.ReflectionManager;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedRecipeHandler
extends TemplateRecipeHandler {
    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "crafting", new Object[0]));
    }

    @Override
    public Class<? extends awv> getGuiClass() {
        return axh.class;
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.shaped", new Object[0]);
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && this.getClass() == ShapedRecipeHandler.class) {
            List allrecipes = aae.a().b();
            for (aag irecipe : allrecipes) {
                CachedShapedRecipe recipe = null;
                if (irecipe instanceof aah) {
                    recipe = new CachedShapedRecipe((aah)irecipe);
                } else if (irecipe instanceof ShapedOreRecipe) {
                    recipe = this.forgeShapedRecipe((ShapedOreRecipe)irecipe);
                }
                if (recipe == null) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(yd result) {
        List allrecipes = aae.a().b();
        for (aag irecipe : allrecipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting(irecipe.b(), result)) continue;
            CachedShapedRecipe recipe = null;
            if (irecipe instanceof aah) {
                recipe = new CachedShapedRecipe((aah)irecipe);
            } else if (irecipe instanceof ShapedOreRecipe) {
                recipe = this.forgeShapedRecipe((ShapedOreRecipe)irecipe);
            }
            if (recipe == null) continue;
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadUsageRecipes(yd ingredient) {
        List allrecipes = aae.a().b();
        for (aag irecipe : allrecipes) {
            CachedShapedRecipe recipe = null;
            if (irecipe instanceof aah) {
                recipe = new CachedShapedRecipe((aah)irecipe);
            } else if (irecipe instanceof ShapedOreRecipe) {
                recipe = this.forgeShapedRecipe((ShapedOreRecipe)irecipe);
            }
            if (recipe == null || !recipe.contains(recipe.ingredients, ingredient.d)) continue;
            recipe.computeVisuals();
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public CachedShapedRecipe forgeShapedRecipe(ShapedOreRecipe recipe) {
        Object[] items;
        int height;
        int width;
        try {
            width = (Integer)ReflectionManager.getField(ShapedOreRecipe.class, Integer.class, (Object)recipe, (int)4);
            height = (Integer)ReflectionManager.getField(ShapedOreRecipe.class, Integer.class, (Object)recipe, (int)5);
            items = (Object[])ReflectionManager.getField(ShapedOreRecipe.class, Object[].class, (Object)recipe, (int)3);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof List && ((List)items[i]).isEmpty()) {
                return null;
            }
            ++i;
        }
        return new CachedShapedRecipe(width, height, items, recipe.b());
    }

    @Override
    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    @Override
    public String getOverlayIdentifier() {
        return "crafting";
    }

    @Override
    public boolean hasOverlay(awv gui, ux container, int recipe) {
        return super.hasOverlay(gui, container, recipe) || this.isRecipe2x2(recipe) && RecipeInfo.hasDefaultOverlay(gui, "crafting2x2");
    }

    @Override
    public IRecipeOverlayRenderer getOverlayRenderer(awv gui, int recipe) {
        IRecipeOverlayRenderer renderer = super.getOverlayRenderer(gui, recipe);
        if (renderer != null) {
            return renderer;
        }
        IStackPositioner positioner = RecipeInfo.getStackPositioner(gui, "crafting2x2");
        if (positioner == null) {
            return null;
        }
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), positioner);
    }

    @Override
    public IOverlayHandler getOverlayHandler(awv gui, int recipe) {
        IOverlayHandler handler = super.getOverlayHandler(gui, recipe);
        if (handler != null) {
            return handler;
        }
        return RecipeInfo.getOverlayHandler(gui, "crafting2x2");
    }

    public boolean isRecipe2x2(int recipe) {
        for (PositionedStack stack : this.getIngredientStacks(recipe)) {
            if (stack.relx <= 43 && stack.rely <= 24) continue;
            return false;
        }
        return true;
    }

    public class CachedShapedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedShapedRecipe(int width, int height, Object[] items, yd out) {
            super(ShapedRecipeHandler.this);
            this.result = new PositionedStack(out, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public CachedShapedRecipe(aah recipe) {
            this(recipe.b, recipe.c, recipe.d, recipe.b());
        }

        public void setIngredients(int width, int height, Object[] items) {
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    if (items[y * width + x] != null) {
                        PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18, false);
                        stack.setMaxSize(1);
                        this.ingredients.add(stack);
                    }
                    ++y;
                }
                ++x;
            }
        }

        @Override
        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(ShapedRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        @Override
        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
            this.result.generatePermutations();
        }
    }
}

