/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.Button;
import codechicken.nei.DropDownFile;
import codechicken.nei.ItemList;
import codechicken.nei.ItemVisibilityHash;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.SaveLoadButton;
import codechicken.nei.Widget;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class DropDownWidget
extends Widget {
    public DropDownFile file = DropDownFile.dropDownInstance;
    private int dropDowna;
    private long lastclicktime;
    private ArrayList<String> mouseovernamestack = new ArrayList();
    private boolean mouseoverTickRecorded;
    public boolean canChangeMouseOver = true;
    public yd hoverItem;
    public SaveLoadButton[] stateButtons = new SaveLoadButton[7];
    public Button[] deleteButtons = new Button[7];
    public int maxheight;
    public int droppedwidth;
    private int relx;
    private int hiddenlevel;
    private LinkedList<Integer> hiddenstack = new LinkedList();
    public static boolean texturedButtons;
    private static final int stacklatency = 4;

    public DropDownWidget() {
        int i = 0;
        while (i < 7) {
            final int savestate = i;
            this.stateButtons[i] = new SaveLoadButton("VIS"){

                @Override
                public void onTextChange() {
                    bx hashSave = NEIClientConfig.global.nbt.l("vis");
                    NEIClientConfig.global.nbt.a("vis", (ck)hashSave);
                    bx statelist = hashSave.l("statename");
                    hashSave.a("statename", (ck)statelist);
                    statelist.a("" + savestate, this.label);
                    NEIClientConfig.global.saveNBT();
                }

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (rightclick) {
                        return false;
                    }
                    if (ItemVisibilityHash.isStateSaved(savestate)) {
                        NEIClientConfig.vishash.loadState(savestate);
                    } else {
                        NEIClientConfig.vishash.saveState(savestate);
                    }
                    return true;
                }
            };
            this.deleteButtons[i] = new Button("x"){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (!rightclick) {
                        NEIClientConfig.vishash.clearState(savestate);
                        return true;
                    }
                    return false;
                }
            };
            this.stateButtons[i].height = 20;
            this.deleteButtons[i].width = 16;
            this.deleteButtons[i].height = 16;
            ++i;
        }
    }

    @Override
    public void draw(int mousex, int mousey) {
        this.hoverItem = null;
        boolean mouseover = super.contains(mousex, mousey);
        texturedButtons = LayoutManager.getLayoutStyle().texturedButtons();
        if (!texturedButtons) {
            GuiDraw.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)(mouseover ? -297791480 : -301989888));
            GuiDraw.drawStringC((String)NEIClientUtils.translate("inventory.item_subsets", new Object[0]), (int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)-1);
        } else {
            GL11.glDisable((int)2896);
            GuiDraw.changeTexture((String)"textures/gui/widgets.png");
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int tex = mouseover ? 2 : 1;
            LayoutManager.drawButtonBackground(this.x - 1, this.y, this.width + 2, this.height, true, tex);
            GuiDraw.drawStringC((String)NEIClientUtils.translate("inventory.item_subsets", new Object[0]), (int)(this.x + this.width / 2), (int)(this.y + (this.height - 8) / 2), (int)(mouseover ? 0xFFFFA0 : 0xE0E0E0));
        }
        if (this.getDropDown() == 1) {
            if (this.mouseovernamestack.size() == 0) {
                this.setDropDown(0);
                return;
            }
            this.updateMouseOver(mousex, mousey);
            this.updatePosition(mousex, mousey);
            this.file.draw(mousex, mousey);
        } else if (this.getDropDown() == 2) {
            this.updateStatePosition();
            this.drawStateButtons(mousex, mousey);
        }
    }

    private void drawStateButtons(int mousex, int mousey) {
        int i = 0;
        while (i < 7) {
            this.stateButtons[i].draw(mousex, mousey);
            this.deleteButtons[i].draw(mousex, mousey);
            ++i;
        }
    }

    private void updateStatePosition() {
        int maxWidth = 0;
        int i = 0;
        while (i < 7) {
            this.deleteButtons[i].x = -1000;
            this.stateButtons[i].y = this.height + 2 + 22 * i;
            bx hashSave = NEIClientConfig.global.nbt.l("vis");
            NEIClientConfig.global.nbt.a("vis", (ck)hashSave);
            bx statelist = hashSave.l("statename");
            hashSave.a("statename", (ck)statelist);
            String name = statelist.i("" + i);
            if (statelist.a("" + i) == null) {
                name = "" + (i + 1);
                statelist.a("" + i, name);
            }
            this.stateButtons[i].label = name;
            this.stateButtons[i].saved = ItemVisibilityHash.isStateSaved(i);
            int buttonw = GuiDraw.getStringWidth((String)this.stateButtons[i].getRenderLabel()) + 26;
            if (buttonw + 22 > this.width) {
                buttonw = this.width - 22;
            }
            if (buttonw > maxWidth) {
                maxWidth = buttonw;
            }
            ++i;
        }
        int buttonx = this.x + (this.width - (maxWidth + 20)) / 2;
        int i2 = 0;
        while (i2 < 7) {
            this.stateButtons[i2].width = maxWidth;
            this.stateButtons[i2].x = buttonx;
            if (this.stateButtons[i2].saved) {
                this.deleteButtons[i2].x = this.stateButtons[i2].x + maxWidth + 2;
                this.deleteButtons[i2].y = this.stateButtons[i2].y + 2;
            }
            ++i2;
        }
    }

    private void updateMouseOver(int mousex, int mousey) {
        String newmouseover = this.file.updateMouseOver(mousex, mousey, this.mouseovernamestack.get(0));
        if (!this.mouseoverTickRecorded) {
            if (this.canChangeMouseOver) {
                String prevmouseover = this.mouseovernamestack.get(this.mouseovernamestack.size() - 1);
                String currentmouseover = this.mouseovernamestack.get(0);
                if (!newmouseover.equals(prevmouseover)) {
                    int i = 0;
                    while (i < this.mouseovernamestack.size()) {
                        this.mouseovernamestack.set(i, currentmouseover);
                        ++i;
                    }
                }
                this.mouseovernamestack.add(newmouseover);
            } else {
                this.mouseovernamestack.add(this.mouseovernamestack.get(this.mouseovernamestack.size() - 1));
            }
            this.mouseoverTickRecorded = true;
        }
        if (this.mouseovernamestack.get(0).equals("") && !LayoutManager.dropDown.contains(mousex, mousey)) {
            this.setDropDown(0);
        }
    }

    private void updatePosition(int mousex, int mousey) {
        this.rehashMaxHeight();
        while (true) {
            int levelwidth;
            this.droppedwidth = 0;
            this.file.position(this.x + this.relx, this.y + this.height);
            if (this.droppedwidth > this.width) {
                levelwidth = this.file.getWidthAtLevel(this.hiddenlevel);
                if (mousex - levelwidth < this.x) {
                    levelwidth = this.droppedwidth - this.width;
                }
                DropDownWidget.moveMouse(-levelwidth, 0);
                mousex -= levelwidth;
                this.relx -= levelwidth;
                this.hiddenstack.addLast(levelwidth);
                ++this.hiddenlevel;
                continue;
            }
            if (this.relx >= 0 || this.width - this.droppedwidth <= this.hiddenstack.getLast()) break;
            levelwidth = this.hiddenstack.getLast();
            if (!this.mouseovernamestack.get(0).equals("")) {
                DropDownWidget.moveMouse(levelwidth, 0);
                mousex += levelwidth;
            }
            this.relx += levelwidth;
            this.hiddenstack.removeLast();
            --this.hiddenlevel;
        }
    }

    public static void moveMouse(int relx, int rely) {
        Dimension res = GuiDraw.displayRes();
        Dimension size = GuiDraw.displaySize();
        Mouse.setCursorPosition((int)(Mouse.getX() + relx * size.width / res.width), (int)(Mouse.getY() + rely * size.height / res.height));
    }

    private void rehashMaxHeight() {
        this.maxheight = GuiDraw.displaySize().height - this.height - this.y - 25;
        this.maxheight = this.maxheight / 18 * 18;
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (super.contains(mousex, mousey)) {
            if (button == 0) {
                if (System.currentTimeMillis() - this.lastclicktime < 300L) {
                    this.file.showAllItems();
                    this.file.updateState();
                    ItemList.updateSearch();
                    NEIClientConfig.vishash.save();
                }
                this.setDropDown(1);
                this.lastclicktime = System.currentTimeMillis();
            } else if (button == 1) {
                if (this.getDropDown() == 2) {
                    this.setDropDown(0);
                } else {
                    this.setDropDown(2);
                }
            }
            return true;
        }
        if (this.getDropDown() == 1) {
            return this.file.click(mousex, mousey, button);
        }
        if (this.getDropDown() == 2) {
            return this.processStateClick(mousex, mousey, button);
        }
        return false;
    }

    private boolean processStateClick(int mousex, int mousey, int button) {
        int i = 0;
        while (i < 7) {
            if (this.stateButtons[i].contains(mousex, mousey) && this.stateButtons[i].handleClick(mousex, mousey, button) || this.deleteButtons[i].contains(mousex, mousey) && this.deleteButtons[i].handleClick(mousex, mousey, button)) {
                return true;
            }
            ++i;
        }
        this.setDropDown(0);
        return false;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        int i = 0;
        while (i < 7) {
            if (this.stateButtons[i].handleKeyPress(keyID, keyChar)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void onGuiClick(int mousex, int mousey) {
        if (this.getDropDown() == 2) {
            int i = 0;
            while (i < 7) {
                this.stateButtons[i].onGuiClick(mousex, mousey);
                ++i;
            }
            if (!this.contains(mousex, mousey)) {
                this.setDropDown(0);
            }
        }
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        if (this.getDropDown() == 1) {
            this.file.mouseUp(mousex, mousey, button);
        }
    }

    @Override
    public boolean contains(int mousex, int mousey) {
        return super.contains(mousex, mousey) || this.getDropDown() == 1 && this.file.contains(mousex, mousey) || this.getDropDown() == 2 && this.statesContain(mousex, mousey);
    }

    private boolean statesContain(int mousex, int mousey) {
        int i = 0;
        while (i < 7) {
            if (this.stateButtons[i].contains(mousex, mousey) || this.deleteButtons[i].contains(mousex, mousey)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean onMouseWheel(int i, int mousex, int mousey) {
        if (this.getDropDown() == 1) {
            this.file.onMouseWheel(-i);
            return true;
        }
        return false;
    }

    public void setHoverItem(yd item) {
        this.hoverItem = item;
    }

    @Override
    public void update() {
        if (this.getDropDown() == 1) {
            if (this.mouseovernamestack.size() == 0) {
                this.setDropDown(0);
                return;
            }
            this.mouseovernamestack.remove(0);
            if (!this.mouseoverTickRecorded) {
                this.mouseovernamestack.add(this.mouseovernamestack.get(this.mouseovernamestack.size() - 1));
            }
            this.mouseoverTickRecorded = false;
        } else if (this.getDropDown() == 2) {
            int i = 0;
            while (i < 7) {
                this.stateButtons[i].update();
                ++i;
            }
        }
    }

    public void setDropDown(int drop) {
        if (drop == 1) {
            this.mouseoverTickRecorded = false;
            this.mouseovernamestack.clear();
            int i = 0;
            while (i < 4) {
                this.mouseovernamestack.add("");
                ++i;
            }
        }
        this.dropDowna = drop;
    }

    public int getDropDown() {
        return this.dropDowna;
    }

    @Override
    public yd getStackMouseOver(int mousex, int mousey) {
        return this.hoverItem;
    }

    @Override
    public List<String> handleTooltip(int mx, int my, List<String> tooltip) {
        return tooltip;
    }
}

