/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.core.inventory.InventoryUtils;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.ClientHandler;
import codechicken.nei.NEIActions;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.PlayerSave;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class NEIServerUtils {
    public static boolean isRaining(abv world) {
        return world.N().p();
    }

    public static void toggleRaining(abv world, boolean notify) {
        boolean raining;
        boolean bl = raining = !world.Q();
        if (!raining) {
            ((jr)world).t.resetRainAndThunder();
        } else {
            world.B();
        }
        if (notify) {
            ServerUtils.sendChatToAll((String)("Rain turned " + (raining ? "on" : "off")));
        }
    }

    public static void healPlayer(ue player) {
        player.f(20.0f);
        player.bH().a(20, 1.0f);
        player.A();
    }

    public static long getTime(abv world) {
        return world.N().g();
    }

    public static void setTime(long l, abv world) {
        world.N().c(l);
    }

    public static void setSlotContents(ue player, int slot, yd item, boolean containerInv) {
        if (slot == -999) {
            player.bn.b(item);
        } else if (containerInv) {
            player.bp.a(slot, item);
        } else {
            player.bn.a(slot, item);
        }
    }

    public static void deleteAllItems(ju player) {
        for (wd slot : player.bp.c) {
            slot.c(null);
        }
        player.a(player.bp, player.bp.a());
    }

    public static void setHourForward(abv world, int hour, boolean notify) {
        long day = NEIServerUtils.getTime(world) / 24000L * 24000L;
        long newTime = day + 24000L + (long)(hour * 1000);
        NEIServerUtils.setTime(newTime, world);
        if (notify) {
            ServerUtils.sendChatToAll((String)("Day " + NEIServerUtils.getTime(world) / 24000L + ". " + hour + ":00"));
        }
    }

    public static void advanceDisabledTimes(abv world) {
        int hour;
        int dim = CommonUtils.getDimension((abv)world);
        int newhour = hour = (int)(NEIServerUtils.getTime(world) % 24000L) / 1000;
        while (NEIServerConfig.isActionDisabled(dim, NEIActions.timeZones[newhour / 6])) {
            newhour = (newhour / 6 + 1) % 4 * 6;
        }
        if (newhour != hour) {
            NEIServerUtils.setHourForward(world, newhour, false);
        }
    }

    public static boolean canItemFitInInventory(ue player, yd itemstack) {
        int i = 0;
        while (i < player.bn.j_() - 4) {
            if (player.bn.a(i) == null) {
                return true;
            }
            ++i;
        }
        if (!itemstack.i()) {
            if (itemstack.e() == 1) {
                return false;
            }
            i = 0;
            while (i < player.bn.j_()) {
                yd invstack = player.bn.a(i);
                if (invstack != null && invstack.d == itemstack.d && invstack.f() && invstack.b < invstack.e() && invstack.b < player.bn.d() && (!invstack.h() || invstack.k() == itemstack.k())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static int getSlotForStack(ux c, int firstSlot, int lastSlot, yd item) {
        wd slot;
        int slotIndex = firstSlot;
        while (slotIndex < lastSlot) {
            int filled;
            slot = c.a(slotIndex);
            if (slot.e() && item.f() && (filled = slot.d().b) < slot.a() && filled < item.e() && NEIServerUtils.areStacksSameType(slot.d(), item)) {
                return slotIndex;
            }
            ++slotIndex;
        }
        slotIndex = firstSlot;
        while (slotIndex < lastSlot) {
            slot = c.a(slotIndex);
            if (!slot.e()) {
                return slotIndex;
            }
            ++slotIndex;
        }
        return -1;
    }

    public static int getSlotForStack(mn inv, int firstSlot, int lastSlot, yd item) {
        int slotIndex = firstSlot;
        while (slotIndex < lastSlot) {
            int filled;
            yd slotStack = inv.a(slotIndex);
            if (slotStack != null && item.f() && (filled = slotStack.b) < inv.d() && filled < item.e() && NEIServerUtils.areStacksSameType(slotStack, item)) {
                return slotIndex;
            }
            ++slotIndex;
        }
        slotIndex = firstSlot;
        while (slotIndex < lastSlot) {
            if (inv.a(slotIndex) == null) {
                return slotIndex;
            }
            ++slotIndex;
        }
        return -1;
    }

    public static void sendNotice(String s, String permission) {
        NEIServerUtils.sendNotice(s, permission, -1);
    }

    public static void sendNotice(String s, String permission, int colour) {
        if (NEIServerConfig.canPlayerPerformAction("CONSOLE", permission)) {
            Logger.getLogger("Minecraft").info(s.replaceAll("\u00a7.", ""));
        }
        for (ju player : ServerUtils.mc().af().a) {
            if (!NEIServerConfig.canPlayerPerformAction(player.bu, permission)) continue;
            ServerUtils.sendChatTo((ju)player, (String)s);
        }
    }

    public static boolean areStacksSameType(yd stack1, yd stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return InventoryUtils.canStack((yd)stack1, (yd)stack2);
    }

    public static boolean areStacksSameTypeCrafting(yd stack1, yd stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.d == stack2.d && (stack1.k() == stack2.k() || stack1.k() == Short.MAX_VALUE || stack2.k() == Short.MAX_VALUE || stack1.b().p());
    }

    public static int compareStacks(yd stack1, yd stack2) {
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1 == null || stack2 == null) {
            return stack1 == null ? -1 : 1;
        }
        if (stack1.d != stack2.d) {
            return stack1.d - stack2.d;
        }
        if (stack1.b != stack2.b) {
            return stack1.b - stack2.b;
        }
        return stack1.k() - stack2.k();
    }

    public static boolean areStacksIdentical(yd stack1, yd stack2) {
        return NEIServerUtils.compareStacks(stack1, stack2) == 0;
    }

    public static void givePlayerItem(ju player, yd stack, boolean infinite, LinkedList<String> name, boolean doGive) {
        if (stack.b() == null) {
            ServerUtils.sendChatTo((ju)player, (String)"\u00a7fNo such item.");
            return;
        }
        StringBuilder namebuilder = new StringBuilder();
        boolean first = true;
        for (String string : name) {
            if (!first) {
                namebuilder.append(" ");
            }
            namebuilder.append(string.trim());
            first = false;
        }
        String itemname = namebuilder.toString();
        int given = 0;
        if (!doGive) {
            given = stack.b;
        } else if (infinite) {
            player.bn.a(stack);
        } else {
            int increment = stack.e();
            given = 0;
            while (given < stack.b) {
                int qty = Math.min(stack.b - given, increment);
                int slotNo = NEIServerUtils.getSlotForStack((mn)player.bn, 0, 36, stack);
                if (slotNo == -1) break;
                yd slotStack = player.bn.a(slotNo);
                int current = slotStack != null ? slotStack.b : 0;
                qty = Math.min(qty, player.bn.d() - current);
                player.bn.a(slotNo, NEIServerUtils.copyStack(stack, qty + current));
                given += qty;
            }
        }
        if (infinite) {
            NEIServerUtils.sendNotice("Giving " + player.bu + " infinite " + "\u00a7f" + itemname, "notify-item");
        } else {
            NEIServerUtils.sendNotice("Giving " + player.bu + " " + given + " of " + "\u00a7f" + itemname, "notify-item");
        }
        player.bp.b();
    }

    public static yd copyStack(yd itemstack, int i) {
        if (itemstack == null) {
            return null;
        }
        itemstack.b += i;
        return itemstack.a(i);
    }

    public static yd copyStack(yd itemstack) {
        if (itemstack == null) {
            return null;
        }
        return NEIServerUtils.copyStack(itemstack, itemstack.b);
    }

    public static void toggleMagnetMode(ju player) {
        PlayerSave playerSave;
        playerSave.enableAction("magnet", !(playerSave = NEIServerConfig.forPlayer(player.bu)).isActionEnabled("magnet"));
    }

    public static int getCreativeMode(ju player) {
        if (NEIServerConfig.forPlayer(player.bu).isActionEnabled("creative+")) {
            return 2;
        }
        if (player.c.d()) {
            return 1;
        }
        if (player.c.b().c()) {
            return 3;
        }
        return 0;
    }

    public static acd getGameType(int mode) {
        switch (mode) {
            case 0: {
                return acd.b;
            }
            case 1: 
            case 2: {
                return acd.c;
            }
            case 3: {
                return acd.d;
            }
        }
        return null;
    }

    public static void setGamemode(ju player, int mode) {
        if (mode < 0 || mode >= NEIActions.gameModes.length || NEIActions.nameActionMap.containsKey(NEIActions.gameModes[mode]) && !NEIServerConfig.canPlayerPerformAction(player.bu, NEIActions.gameModes[mode])) {
            return;
        }
        player.c.a(NEIServerUtils.getGameType(mode));
        NEIServerConfig.forPlayer(player.bu).enableAction("creative+", mode == 2);
        new PacketCustom((Object)"NEI", 14).writeByte(mode).sendToPlayer((ue)player);
        player.a(cu.e((String)("nei.chat.gamemode." + mode)));
    }

    public static void cycleCreativeInv(ju player, int steps) {
        int col;
        int col2;
        uc inventory = player.bn;
        yd[][] slots = new yd[10][9];
        PlayerSave playerSave = NEIServerConfig.forPlayer(player.bu);
        int hotbar = 0;
        while (hotbar < 9) {
            slots[9][hotbar] = inventory.a[hotbar];
            ++hotbar;
        }
        int row = 0;
        while (row < 3) {
            col2 = 0;
            while (col2 < 9) {
                slots[row + 6][col2] = inventory.a[(row + 1) * 9 + col2];
                ++col2;
            }
            ++row;
        }
        row = 0;
        while (row < 6) {
            col2 = 0;
            while (col2 < 9) {
                slots[row][col2] = playerSave.creativeInv[row * 9 + col2];
                ++col2;
            }
            ++row;
        }
        yd[][] newslots = new yd[10][];
        int row2 = 0;
        while (row2 < 10) {
            newslots[(row2 + steps + 10) % 10] = slots[row2];
            ++row2;
        }
        int hotbar2 = 0;
        while (hotbar2 < 9) {
            inventory.a[hotbar2] = newslots[9][hotbar2];
            ++hotbar2;
        }
        row2 = 0;
        while (row2 < 3) {
            col = 0;
            while (col < 9) {
                inventory.a[(row2 + 1) * 9 + col] = newslots[row2 + 6][col];
                ++col;
            }
            ++row2;
        }
        row2 = 0;
        while (row2 < 6) {
            col = 0;
            while (col < 9) {
                playerSave.creativeInv[row2 * 9 + col] = newslots[row2][col];
                ++col;
            }
            ++row2;
        }
        playerSave.setDirty();
    }

    public static List<int[]> getEnchantments(yd itemstack) {
        cf nbttaglist;
        ArrayList<int[]> arraylist = new ArrayList<int[]>();
        if (itemstack != null && (nbttaglist = itemstack.r()) != null) {
            int i = 0;
            while (i < nbttaglist.c()) {
                bx tag = (bx)nbttaglist.b(i);
                arraylist.add(new int[]{tag.d("id"), tag.d("lvl")});
                ++i;
            }
        }
        return arraylist;
    }

    public static boolean stackHasEnchantment(yd itemstack, int e) {
        List<int[]> allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantmentLevel(yd itemstack, int e) {
        List<int[]> allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return ai[1];
        }
        return -1;
    }

    public static boolean doesEnchantmentConflict(List<int[]> enchantments, aat e) {
        for (int[] ai : enchantments) {
            if (e.a(aat.b[ai[0]])) continue;
            return true;
        }
        return false;
    }

    public static RuntimeException throwCME(String msg) {
        if (CommonUtils.isClient()) {
            return ClientHandler.throwCME(msg);
        }
        throw new RuntimeException(msg);
    }

    public static yd[] extractRecipeItems(Object obj) {
        if (obj instanceof yd) {
            return new yd[]{(yd)obj};
        }
        if (obj instanceof yd[]) {
            return (yd[])obj;
        }
        if (obj instanceof List) {
            return ((List)obj).toArray(new yd[0]);
        }
        throw new ClassCastException("not an ItemStack, ItemStack[] or List<ItemStack?");
    }
}

