/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CCUpdateChecker;
import codechicken.core.ClassDiscoverer;
import codechicken.core.ClientUtils;
import codechicken.core.CommonUtils;
import codechicken.core.IStringMatcher;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.ConfigTagParent;
import codechicken.lib.inventory.ItemKey;
import codechicken.nei.ItemVisibilityHash;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIActions;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.api.API;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.api.LayoutStyle;
import codechicken.nei.api.NEIInfo;
import codechicken.nei.api.TaggedInventoryArea;
import codechicken.nei.asm.NEIModContainer;
import codechicken.nei.config.ConfigSet;
import codechicken.nei.config.IConfigSetHolder;
import codechicken.nei.config.OptionCycled;
import codechicken.nei.config.OptionGamemodes;
import codechicken.nei.config.OptionHighlightTips;
import codechicken.nei.config.OptionList;
import codechicken.nei.config.OptionTextField;
import codechicken.nei.config.OptionToggleButton;
import codechicken.nei.config.OptionUtilities;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.obfuscator.ObfuscationRun;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NEIClientConfig {
    private static boolean configLoaded;
    private static boolean enabledOverride;
    public static ConfigSet global;
    public static ConfigSet world;
    public static ItemVisibilityHash vishash;
    public static ye[] creativeInv;
    private static boolean[] statesSaved;
    public static boolean hasSMPCounterpart;
    public static HashSet<String> permissableActions;
    public static HashSet<String> disabledActions;
    public static HashSet<String> enabledActions;
    public static HashSet<ItemKey> bannedBlocks;

    private static File moveGlobalDat() {
        File oldFile = new File(CommonUtils.getMinecraftDir(), "saves/NEI.dat");
        File newFile = new File(CommonUtils.getMinecraftDir(), "saves/NEI/NEI.dat");
        if (oldFile.exists()) {
            oldFile.renameTo(newFile);
        }
        return newFile;
    }

    private static void setDefaults() {
        ConfigTagParent tag = NEIClientConfig.global.config;
        tag.setComment("Main configuration of NEI.\nMost of these options can be changed ingame.\nDeleting any element will restore it to it's default value");
        tag.getTag("command").useBraces().setComment("Change these options if you have a different mod installed on the server that handles the commands differently, Eg. Bukkit Essentials");
        tag.setNewLineMode(1);
        tag.getTag("inventory.widgetsenabled").getBooleanValue(true);
        API.addOption(new OptionToggleButton("inventory.widgetsenabled"));
        tag.getTag("inventory.hidden").getBooleanValue(false);
        tag.getTag("inventory.cheatmode").getIntValue(2);
        tag.getTag("inventory.lockmode").setComment("For those who can't help themselves.\nSet this to a mode and you will be unable to change it ingame").getIntValue(-1);
        API.addOption(new OptionCycled("inventory.cheatmode", 3){

            @Override
            public boolean optionValid(int index) {
                return NEIClientConfig.getLockedMode() == -1 || NEIClientConfig.getLockedMode() == index && NEIInfo.isValidMode(index);
            }
        });
        NEIClientConfig.checkCheatMode();
        tag.getTag("inventory.utilities").setDefaultValue("delete, magnet");
        API.addOption(new OptionUtilities("inventory.utilities"));
        tag.getTag("inventory.gamemodes").setDefaultValue("creative, creative+, adventure");
        API.addOption(new OptionGamemodes("inventory.gamemodes"));
        tag.getTag("inventory.layoutstyle").getIntValue(0);
        API.addOption(new OptionCycled("inventory.layoutstyle", 0){

            @Override
            public String getPrefix() {
                return this.translateN(this.name, new Object[0]);
            }

            @Override
            public String getButtonText() {
                return NEIClientUtils.translate("layoutstyle." + LayoutManager.getLayoutStyle(this.renderTag().getIntValue()).getName(), new Object[0]);
            }

            @Override
            public boolean cycle() {
                LinkedList<Integer> list = new LinkedList<Integer>();
                for (Map.Entry<Integer, LayoutStyle> entry : LayoutManager.layoutStyles.entrySet()) {
                    list.add(entry.getKey());
                }
                Collections.sort(list);
                int nextLayout = this.getTag().getIntValue();
                if (nextLayout == (Integer)list.getLast()) {
                    nextLayout = -1;
                }
                for (Integer i : list) {
                    if (i <= nextLayout) continue;
                    nextLayout = i;
                    break;
                }
                this.getTag().setIntValue(nextLayout);
                return true;
            }
        });
        tag.getTag("options.edge-align buttons").setPosition(7).getBooleanValue(false);
        tag.getTag("inventory.itemIDs").getIntValue(1);
        API.addOption(new OptionCycled("inventory.itemIDs", 3, true));
        tag.getTag("world.highlight_tips").getBooleanValue(false);
        tag.getTag("world.highlight_tips.x").getIntValue(5000);
        tag.getTag("world.highlight_tips.y").getIntValue(100);
        API.addOption(new OptionHighlightTips("world.highlight_tips"));
        tag.getTag("inventory.profileRecipes").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.profileRecipes", true));
        tag.getTag("command.creative").setDefaultValue("/gamemode {0} {1}");
        API.addOption(new OptionTextField("command.creative"));
        tag.getTag("command.item").setDefaultValue("/give {0} {1} {2} {3}");
        API.addOption(new OptionTextField("command.item"));
        tag.getTag("command.time").setDefaultValue("/time set {0}");
        API.addOption(new OptionTextField("command.time"));
        tag.getTag("command.rain").setDefaultValue("/toggledownfall");
        API.addOption(new OptionTextField("command.rain"));
        tag.getTag("command.heal").setDefaultValue("");
        API.addOption(new OptionTextField("command.heal"));
        NEIClientConfig.setDefaultKeyBindings();
    }

    private static void linkOptionList() {
        NEIClientConfig.getOptionList().bindConfig(new IConfigSetHolder(){

            @Override
            public ConfigSet worldConfigSet() {
                return world;
            }

            @Override
            public ConfigSet globalConfigSet() {
                return global;
            }
        });
    }

    private static void setDefaultKeyBindings() {
        API.addKeyBind("gui.recipe", 19);
        API.addKeyBind("gui.usage", 22);
        API.addKeyBind("gui.back", 14);
        API.addKeyBind("gui.enchant", 45);
        API.addKeyBind("gui.potion", 25);
        API.addKeyBind("gui.prev", 201);
        API.addKeyBind("gui.next", 209);
        API.addKeyBind("gui.hide", 24);
        API.addKeyBind("gui.search", 33);
        API.addKeyBind("world.chunkoverlay", 67);
        API.addKeyBind("world.moboverlay", 65);
        API.addKeyBind("world.highlight_tips", 82);
        API.addKeyBind("world.dawn", 0);
        API.addKeyBind("world.noon", 0);
        API.addKeyBind("world.dusk", 0);
        API.addKeyBind("world.midnight", 0);
        API.addKeyBind("world.rain", 0);
        API.addKeyBind("world.heal", 0);
        API.addKeyBind("world.creative", 0);
    }

    public static OptionList getOptionList() {
        return OptionList.getOptionList("nei.options");
    }

    public static void loadWorld(String saveName) {
        boolean newWorld;
        NEIClientConfig.setInternalEnabled(true);
        System.out.println("Loading World: " + saveName);
        NEIClientConfig.bootNEI(ClientUtils.getWorld());
        File saveDir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/" + saveName);
        boolean bl = newWorld = !saveDir.exists();
        if (newWorld) {
            saveDir.mkdirs();
        }
        world = new ConfigSet(new File(saveDir, "NEI.dat"), (ConfigTagParent)new ConfigFile(new File(saveDir, "NEI.cfg")));
        NEIClientConfig.onWorldLoad(newWorld);
    }

    private static void onWorldLoad(boolean newWorld) {
        NEIClientConfig.world.config.setComment("World based configuration of NEI.\nMost of these options can be changed ingame.\nDeleting any element will restore it to it's default value");
        NEIClientConfig.setWorldDefaults();
        creativeInv = new ye[54];
        LayoutManager.searchField.setText(NEIClientConfig.getSearchExpression());
        LayoutManager.quantity.setText(Integer.toString(NEIClientConfig.getItemQuantity()));
        if (newWorld && ClientUtils.isLocal()) {
            NEIClientConfig.world.config.getTag("inventory.cheatmode").setIntValue(NEIClientUtils.getGamemode() == 1 ? 2 : 0);
        }
        NEIInfo.load(ClientUtils.getWorld());
    }

    private static void setWorldDefaults() {
        by nbt = NEIClientConfig.world.nbt;
        if (!nbt.b("search")) {
            nbt.a("search", "");
        }
        if (!nbt.b("quantity")) {
            nbt.a("quantity", 0);
        }
        if (!nbt.b("validateenchantments")) {
            nbt.a("validateenchantments", false);
        }
        world.saveNBT();
    }

    public static int getKeyBinding(String string) {
        return NEIClientConfig.getSetting("keys." + string).getIntValue();
    }

    public static void setDefaultKeyBinding(String string, int key) {
        NEIClientConfig.getSetting("keys." + string).getIntValue(key);
    }

    public static void bootNEI(abw world) {
        if (configLoaded) {
            return;
        }
        NEIClientConfig.loadStates();
        ItemVisibilityHash.loadStates();
        vishash = new ItemVisibilityHash();
        ItemInfo.load(world);
        GuiInfo.load();
        RecipeInfo.load();
        LayoutManager.load();
        NEIController.load();
        configLoaded = true;
        ClassDiscoverer classDiscoverer = new ClassDiscoverer(new IStringMatcher(){

            public boolean matches(String test) {
                return test.startsWith("NEI") && test.endsWith("Config.class");
            }
        }, new Class[]{IConfigureNEI.class});
        classDiscoverer.findClasses();
        for (Class class1 : classDiscoverer.classes) {
            try {
                IConfigureNEI config = (IConfigureNEI)class1.newInstance();
                config.loadConfig();
                NEIModContainer.plugins.add(config);
                System.out.println("Loaded " + class1.getName());
            }
            catch (Exception e) {
                System.out.println("Failed to Load " + class1.getName());
                e.printStackTrace();
            }
        }
    }

    public static void loadStates() {
        for (int state = 0; state < 7; ++state) {
            NEIClientConfig.statesSaved[state] = !NEIClientConfig.global.nbt.l("save" + state).d();
        }
    }

    public static boolean isWorldSpecific(String setting) {
        return world != null && NEIClientConfig.world.config.containsTag(setting);
    }

    public static boolean isStateSaved(int i) {
        return statesSaved[i];
    }

    public static ConfigTag getSetting(String s) {
        return NEIClientConfig.isWorldSpecific(s) ? NEIClientConfig.world.config.getTag(s) : NEIClientConfig.global.config.getTag(s);
    }

    public static boolean getBooleanSetting(String s) {
        return NEIClientConfig.getSetting(s).getBooleanValue();
    }

    public static boolean isHidden() {
        return !enabledOverride || NEIClientConfig.getBooleanSetting("inventory.hidden");
    }

    public static boolean isEnabled() {
        return enabledOverride && NEIClientConfig.getBooleanSetting("inventory.widgetsenabled");
    }

    public static void setEnabled(boolean flag) {
        NEIClientConfig.getSetting("inventory.widgetsenabled").setBooleanValue(flag);
    }

    public static int getItemQuantity() {
        return NEIClientConfig.world.nbt.e("quantity");
    }

    public static int getCheatMode() {
        return NEIClientConfig.getIntSetting("inventory.cheatmode");
    }

    private static void checkCheatMode() {
        if (NEIClientConfig.getLockedMode() != -1) {
            NEIClientConfig.setIntSetting("inventory.cheatmode", NEIClientConfig.getLockedMode());
        }
    }

    public static int getLockedMode() {
        return NEIClientConfig.getIntSetting("inventory.lockmode");
    }

    public static int getLayoutStyle() {
        return NEIClientConfig.getIntSetting("inventory.layoutstyle");
    }

    public static String getStringSetting(String s) {
        return NEIClientConfig.getSetting(s).getValue();
    }

    public static boolean canDump() {
        return NEIClientConfig.getBooleanSetting("ID dump.itemIDs") || NEIClientConfig.getBooleanSetting("ID dump.blockIDs") || NEIClientConfig.getBooleanSetting("ID dump.unused itemIDs") || NEIClientConfig.getBooleanSetting("ID dump.unused blockIDs");
    }

    public static boolean showIDs() {
        int i = NEIClientConfig.getIntSetting("inventory.itemIDs");
        return i == 2 || i == 1 && NEIClientConfig.isEnabled() && !NEIClientConfig.isHidden();
    }

    public static void toggleBooleanSetting(String setting) {
        ConfigTag tag;
        tag.setBooleanValue(!(tag = NEIClientConfig.getSetting(setting)).getBooleanValue());
    }

    public static void cycleSetting(String setting, int max) {
        ConfigTag tag = NEIClientConfig.getSetting(setting);
        tag.setIntValue((tag.getIntValue() + 1) % max);
    }

    public static int getIntSetting(String setting) {
        return NEIClientConfig.getSetting(setting).getIntValue();
    }

    public static void setIntSetting(String setting, int val) {
        NEIClientConfig.getSetting(setting).setIntValue(val);
    }

    public static String getSearchExpression() {
        return NEIClientConfig.world.nbt.i("search");
    }

    public static void setSearchExpression(String expression) {
        NEIClientConfig.world.nbt.a("search", expression);
        world.saveNBT();
    }

    public static boolean getMagnetMode() {
        return enabledActions.contains("magnet");
    }

    public static boolean invCreativeMode() {
        return enabledActions.contains("creative+") && NEIClientConfig.canPerformAction("creative+");
    }

    public static boolean areDamageVariantsShown() {
        return NEIClientConfig.hasSMPCounterPart() || NEIClientConfig.getSetting("command.item").getValue().contains("{3}");
    }

    public static void clearState(int state) {
        NEIClientConfig.statesSaved[state] = false;
        NEIClientConfig.global.nbt.a("save" + state, (cl)new by());
        global.saveNBT();
    }

    public static void loadState(int state) {
        if (!statesSaved[state]) {
            return;
        }
        by statesave = NEIClientConfig.global.nbt.l("save" + state);
        awy currentContainer = NEIClientUtils.getGuiContainer();
        LinkedList<TaggedInventoryArea> saveAreas = new LinkedList<TaggedInventoryArea>();
        saveAreas.add(new TaggedInventoryArea(NEIClientUtils.mc().h.bn));
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            List<TaggedInventoryArea> areaList = handler.getInventoryAreas(currentContainer);
            if (areaList == null) continue;
            saveAreas.addAll(areaList);
        }
        for (TaggedInventoryArea area : saveAreas) {
            if (!statesave.b(area.tag)) continue;
            for (int slot : area.slots) {
                NEIClientUtils.setSlotContents(slot, null, area.isContainer());
            }
            cg areaTag = statesave.m(area.tag);
            for (int i = 0; i < areaTag.c(); ++i) {
                by stacksave = (by)areaTag.b(i);
                int slot = stacksave.c("Slot") & 0xFF;
                if (!area.slots.contains(slot)) continue;
                NEIClientUtils.setSlotContents(slot, ye.a((by)stacksave), area.isContainer());
            }
        }
    }

    public static void saveState(int state) {
        by statesave = NEIClientConfig.global.nbt.l("save" + state);
        awy currentContainer = NEIClientUtils.getGuiContainer();
        LinkedList<TaggedInventoryArea> saveAreas = new LinkedList<TaggedInventoryArea>();
        saveAreas.add(new TaggedInventoryArea(NEIClientUtils.mc().h.bn));
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            List<TaggedInventoryArea> areaList = handler.getInventoryAreas(currentContainer);
            if (areaList == null) continue;
            saveAreas.addAll(areaList);
        }
        for (TaggedInventoryArea area : saveAreas) {
            cg areaTag = new cg(area.tag);
            for (int i : area.slots) {
                ye stack = area.getStackInSlot(i);
                if (stack == null) continue;
                by stacksave = new by();
                stacksave.a("Slot", (byte)i);
                stack.b(stacksave);
                areaTag.a((cl)stacksave);
            }
            statesave.a(area.tag, (cl)areaTag);
        }
        NEIClientConfig.global.nbt.a("save" + state, (cl)statesave);
        global.saveNBT();
        NEIClientConfig.statesSaved[state] = true;
    }

    public static boolean hasSMPCounterPart() {
        return hasSMPCounterpart;
    }

    public static void setHasSMPCounterPart(boolean flag) {
        hasSMPCounterpart = flag;
        permissableActions.clear();
        bannedBlocks.clear();
        disabledActions.clear();
        enabledActions.clear();
    }

    public static boolean canPerformAction(String name) {
        if (!NEIClientConfig.isEnabled()) {
            return false;
        }
        if (!NEIClientConfig.modePermitsAction(name)) {
            return false;
        }
        String base = NEIActions.base(name);
        if (hasSMPCounterpart) {
            return permissableActions.contains(base);
        }
        if (NEIActions.smpRequired(name)) {
            return false;
        }
        String cmd = NEIClientConfig.getStringSetting("command." + base);
        return cmd != null && cmd.startsWith("/");
    }

    private static boolean modePermitsAction(String name) {
        String[] actions;
        if (NEIClientConfig.getCheatMode() == 0) {
            return false;
        }
        if (NEIClientConfig.getCheatMode() == 2) {
            return true;
        }
        for (String action : actions = NEIClientConfig.getStringArrSetting("inventory.utilities")) {
            if (!action.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static String[] getStringArrSetting(String s) {
        return NEIClientConfig.getStringSetting(s).replace(" ", "").split(",");
    }

    public static void setBannedBlocks(ArrayList<ItemKey> ahash) {
        bannedBlocks.clear();
        for (ItemKey hash : ahash) {
            bannedBlocks.add(hash);
        }
    }

    public static boolean canGetItem(ItemKey item) {
        return !bannedBlocks.contains(item);
    }

    public static void setInternalEnabled(boolean b) {
        enabledOverride = b;
    }

    public static void reloadSaves() {
        File saveDir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/local");
        if (!saveDir.exists()) {
            return;
        }
        List saves = atv.w().b().b();
        HashSet<String> saveFileNames = new HashSet<String>();
        for (amg save : saves) {
            saveFileNames.add(save.a());
        }
        for (File file : saveDir.listFiles()) {
            if (!file.isDirectory() || saveFileNames.contains(file.getName())) continue;
            ObfuscationRun.deleteDir((File)file, (boolean)true);
        }
    }

    static {
        global = new ConfigSet(NEIClientConfig.moveGlobalDat(), (ConfigTagParent)new ConfigFile(new File(CommonUtils.getMinecraftDir(), "config/NEI.cfg")));
        statesSaved = new boolean[7];
        permissableActions = new HashSet();
        disabledActions = new HashSet();
        enabledActions = new HashSet();
        bannedBlocks = new HashSet();
        if (NEIClientConfig.global.config.getTag("checkUpdates").getBooleanValue(true)) {
            CCUpdateChecker.updateCheck((String)"NotEnoughItems");
        }
        NEIClientConfig.linkOptionList();
        NEIClientConfig.setDefaults();
    }
}

