/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.ClientHandler;
import codechicken.nei.NEIActions;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.PlayerSave;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class NEIServerUtils {
    public static boolean isRaining(abw world) {
        return world.N().p();
    }

    public static void toggleRaining(abw world, boolean notify) {
        boolean raining;
        boolean bl = raining = !world.Q();
        if (!raining) {
            ((js)world).t.resetRainAndThunder();
        } else {
            world.B();
        }
        if (notify) {
            ServerUtils.sendChatToAll((String)("Rain turned " + (raining ? "on" : "off")));
        }
    }

    public static void healPlayer(uf player) {
        player.f(20.0f);
        player.bI().a(20, 1.0f);
        player.B();
    }

    public static long getTime(abw world) {
        return world.N().g();
    }

    public static void setTime(long l, abw world) {
        world.N().c(l);
    }

    public static void setSlotContents(uf player, int slot, ye item, boolean containerInv) {
        if (slot == -999) {
            player.bn.b(item);
        } else if (containerInv) {
            player.bp.a(slot, item);
        } else {
            player.bn.a(slot, item);
        }
    }

    public static ye getSlotContents(uf player, int slot, boolean containerInv) {
        if (slot == -999) {
            return player.bn.o();
        }
        if (containerInv) {
            return player.bp.a(slot).d();
        }
        return player.bn.a(slot);
    }

    public static void deleteAllItems(jv player) {
        for (we slot : player.bp.c) {
            slot.c(null);
        }
        player.a(player.bp, player.bp.a());
    }

    public static void setHourForward(abw world, int hour, boolean notify) {
        long day = NEIServerUtils.getTime(world) / 24000L * 24000L;
        long newTime = day + 24000L + (long)(hour * 1000);
        NEIServerUtils.setTime(newTime, world);
        if (notify) {
            ServerUtils.sendChatToAll((String)("Day " + NEIServerUtils.getTime(world) / 24000L + ". " + hour + ":00"));
        }
    }

    public static void advanceDisabledTimes(abw world) {
        int hour;
        int dim = CommonUtils.getDimension((abw)world);
        int newhour = hour = (int)(NEIServerUtils.getTime(world) % 24000L) / 1000;
        while (NEIServerConfig.isActionDisabled(dim, NEIActions.timeZones[newhour / 6])) {
            newhour = (newhour / 6 + 1) % 4 * 6;
        }
        if (newhour != hour) {
            NEIServerUtils.setHourForward(world, newhour, false);
        }
    }

    public static boolean canItemFitInInventory(uf player, ye itemstack) {
        int i;
        for (i = 0; i < player.bn.j_() - 4; ++i) {
            if (player.bn.a(i) != null) continue;
            return true;
        }
        if (!itemstack.i()) {
            if (itemstack.e() == 1) {
                return false;
            }
            for (i = 0; i < player.bn.j_(); ++i) {
                ye invstack = player.bn.a(i);
                if (invstack == null || invstack.d != itemstack.d || !invstack.f() || invstack.b >= invstack.e() || invstack.b >= player.bn.d() || invstack.h() && invstack.k() != itemstack.k()) continue;
                return true;
            }
        }
        return false;
    }

    public static int getSlotForStack(uy c, int firstSlot, int lastSlot, ye item) {
        we slot;
        int slotIndex;
        for (slotIndex = firstSlot; slotIndex < lastSlot; ++slotIndex) {
            int filled;
            slot = c.a(slotIndex);
            if (!slot.e() || !item.f() || (filled = slot.d().b) >= slot.a() || filled >= item.e() || !NEIServerUtils.areStacksSameType(slot.d(), item)) continue;
            return slotIndex;
        }
        for (slotIndex = firstSlot; slotIndex < lastSlot; ++slotIndex) {
            slot = c.a(slotIndex);
            if (slot.e()) continue;
            return slotIndex;
        }
        return -1;
    }

    public static int getSlotForStack(mo inv, int firstSlot, int lastSlot, ye item) {
        int slotIndex;
        for (slotIndex = firstSlot; slotIndex < lastSlot; ++slotIndex) {
            int filled;
            ye slotStack = inv.a(slotIndex);
            if (slotStack == null || !item.f() || (filled = slotStack.b) >= inv.d() || filled >= item.e() || !NEIServerUtils.areStacksSameType(slotStack, item)) continue;
            return slotIndex;
        }
        for (slotIndex = firstSlot; slotIndex < lastSlot; ++slotIndex) {
            if (inv.a(slotIndex) != null) continue;
            return slotIndex;
        }
        return -1;
    }

    public static void sendNotice(String s, String permission) {
        NEIServerUtils.sendNotice(s, permission, -1);
    }

    public static void sendNotice(String s, String permission, int colour) {
        if (NEIServerConfig.canPlayerPerformAction("CONSOLE", permission)) {
            Logger.getLogger("Minecraft").info(s.replaceAll("\u00a7.", ""));
        }
        for (jv player : ServerUtils.mc().af().a) {
            if (!NEIServerConfig.canPlayerPerformAction(player.bu, permission)) continue;
            ServerUtils.sendChatTo((jv)player, (String)s);
        }
    }

    public static boolean areStacksSameType(ye stack1, ye stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return InventoryUtils.canStack((ye)stack1, (ye)stack2);
    }

    public static boolean areStacksSameTypeCrafting(ye stack1, ye stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.d == stack2.d && (stack1.k() == stack2.k() || stack1.k() == Short.MAX_VALUE || stack2.k() == Short.MAX_VALUE || stack1.b().p());
    }

    public static int compareStacks(ye stack1, ye stack2) {
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1 == null || stack2 == null) {
            return stack1 == null ? -1 : 1;
        }
        if (stack1.d != stack2.d) {
            return stack1.d - stack2.d;
        }
        if (stack1.b != stack2.b) {
            return stack1.b - stack2.b;
        }
        return stack1.k() - stack2.k();
    }

    public static boolean areStacksIdentical(ye stack1, ye stack2) {
        return NEIServerUtils.compareStacks(stack1, stack2) == 0;
    }

    public static void givePlayerItem(jv player, ye stack, boolean infinite, LinkedList<String> name, boolean doGive) {
        if (stack.b() == null) {
            ServerUtils.sendChatTo((jv)player, (String)"\u00a7fNo such item.");
            return;
        }
        StringBuilder namebuilder = new StringBuilder();
        boolean first = true;
        for (String string : name) {
            if (!first) {
                namebuilder.append(" ");
            }
            namebuilder.append(string.trim());
            first = false;
        }
        String itemname = namebuilder.toString();
        int given = 0;
        if (!doGive) {
            given = stack.b;
        } else if (infinite) {
            player.bn.a(stack);
        } else {
            int qty;
            int increment = stack.e();
            for (given = 0; given < stack.b; given += qty) {
                qty = Math.min(stack.b - given, increment);
                int slotNo = NEIServerUtils.getSlotForStack((mo)player.bn, 0, 36, stack);
                if (slotNo == -1) break;
                ye slotStack = player.bn.a(slotNo);
                int current = slotStack != null ? slotStack.b : 0;
                qty = Math.min(qty, player.bn.d() - current);
                player.bn.a(slotNo, NEIServerUtils.copyStack(stack, qty + current));
            }
        }
        if (infinite) {
            NEIServerUtils.sendNotice("Giving " + player.bu + " infinite " + "\u00a7f" + itemname, "notify-item");
        } else {
            NEIServerUtils.sendNotice("Giving " + player.bu + " " + given + " of " + "\u00a7f" + itemname, "notify-item");
        }
        player.bp.b();
    }

    public static ye copyStack(ye itemstack, int i) {
        if (itemstack == null) {
            return null;
        }
        itemstack.b += i;
        return itemstack.a(i);
    }

    public static ye copyStack(ye itemstack) {
        if (itemstack == null) {
            return null;
        }
        return NEIServerUtils.copyStack(itemstack, itemstack.b);
    }

    public static void toggleMagnetMode(jv player) {
        PlayerSave playerSave;
        playerSave.enableAction("magnet", !(playerSave = NEIServerConfig.forPlayer(player.bu)).isActionEnabled("magnet"));
    }

    public static int getCreativeMode(jv player) {
        if (NEIServerConfig.forPlayer(player.bu).isActionEnabled("creative+")) {
            return 2;
        }
        if (player.c.d()) {
            return 1;
        }
        if (player.c.b().c()) {
            return 3;
        }
        return 0;
    }

    public static ace getGameType(int mode) {
        switch (mode) {
            case 0: {
                return ace.b;
            }
            case 1: 
            case 2: {
                return ace.c;
            }
            case 3: {
                return ace.d;
            }
        }
        return null;
    }

    public static void setGamemode(jv player, int mode) {
        if (mode < 0 || mode >= NEIActions.gameModes.length || NEIActions.nameActionMap.containsKey(NEIActions.gameModes[mode]) && !NEIServerConfig.canPlayerPerformAction(player.bu, NEIActions.gameModes[mode])) {
            return;
        }
        player.c.a(NEIServerUtils.getGameType(mode));
        NEIServerConfig.forPlayer(player.bu).enableAction("creative+", mode == 2);
        new PacketCustom((Object)"NEI", 14).writeByte(mode).sendToPlayer((uf)player);
        player.a(cv.e((String)("nei.chat.gamemode." + mode)));
    }

    public static void cycleCreativeInv(jv player, int steps) {
        int col;
        int row;
        int col2;
        int row2;
        ud inventory = player.bn;
        ye[][] slots = new ye[10][9];
        PlayerSave playerSave = NEIServerConfig.forPlayer(player.bu);
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            slots[9][hotbar] = inventory.a[hotbar];
        }
        for (row2 = 0; row2 < 3; ++row2) {
            for (col2 = 0; col2 < 9; ++col2) {
                slots[row2 + 6][col2] = inventory.a[(row2 + 1) * 9 + col2];
            }
        }
        for (row2 = 0; row2 < 6; ++row2) {
            for (col2 = 0; col2 < 9; ++col2) {
                slots[row2][col2] = playerSave.creativeInv[row2 * 9 + col2];
            }
        }
        ye[][] newslots = new ye[10][];
        for (row = 0; row < 10; ++row) {
            newslots[(row + steps + 10) % 10] = slots[row];
        }
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            inventory.a[hotbar] = newslots[9][hotbar];
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                inventory.a[(row + 1) * 9 + col] = newslots[row + 6][col];
            }
        }
        for (row = 0; row < 6; ++row) {
            for (col = 0; col < 9; ++col) {
                playerSave.creativeInv[row * 9 + col] = newslots[row][col];
            }
        }
        playerSave.setDirty();
    }

    public static List<int[]> getEnchantments(ye itemstack) {
        cg nbttaglist;
        ArrayList<int[]> arraylist = new ArrayList<int[]>();
        if (itemstack != null && (nbttaglist = itemstack.r()) != null) {
            for (int i = 0; i < nbttaglist.c(); ++i) {
                by tag = (by)nbttaglist.b(i);
                arraylist.add(new int[]{tag.d("id"), tag.d("lvl")});
            }
        }
        return arraylist;
    }

    public static boolean stackHasEnchantment(ye itemstack, int e) {
        List<int[]> allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantmentLevel(ye itemstack, int e) {
        List<int[]> allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return ai[1];
        }
        return -1;
    }

    public static boolean doesEnchantmentConflict(List<int[]> enchantments, aau e) {
        for (int[] ai : enchantments) {
            if (e.a(aau.b[ai[0]])) continue;
            return true;
        }
        return false;
    }

    public static RuntimeException throwCME(String msg) {
        if (CommonUtils.isClient()) {
            return ClientHandler.throwCME(msg);
        }
        throw new RuntimeException(msg);
    }

    public static ye[] extractRecipeItems(Object obj) {
        if (obj instanceof ye) {
            return new ye[]{(ye)obj};
        }
        if (obj instanceof ye[]) {
            return (ye[])obj;
        }
        if (obj instanceof List) {
            return ((List)obj).toArray(new ye[0]);
        }
        throw new ClassCastException("not an ItemStack, ItemStack[] or List<ItemStack?");
    }
}

