/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.core.gui.GuiCCButton;
import codechicken.core.gui.GuiScreenWidget;
import codechicken.core.gui.GuiWidget;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.HUDRenderer;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.config.Option;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class GuiHighlightTips
extends GuiScreenWidget {
    private String name;
    private GuiCCButton toggleButton;
    private Option opt;
    private Point dragDown;

    public GuiHighlightTips(Option opt) {
        super(80, 20);
        this.opt = opt;
        this.name = opt.name;
    }

    public boolean func_73868_f() {
        return true;
    }

    public void addWidgets() {
        this.toggleButton = new GuiCCButton(0, 0, 80, 20, "").setActionCommand("show");
        this.add((GuiWidget)this.toggleButton);
        this.updateNames();
    }

    public void actionPerformed(String ident, Object ... params) {
        if (ident.equals("show")) {
            this.opt.getTag(this.name).setBooleanValue(!this.show());
            this.updateNames();
        }
    }

    private void updateNames() {
        this.toggleButton.text = NEIClientUtils.translate("options." + this.name + "." + (this.show() ? "show" : "hide"), new Object[0]);
    }

    private boolean show() {
        return this.opt.renderTag(this.name).getBooleanValue();
    }

    public void func_73869_a(char c, int keycode) throws IOException {
        if (keycode == 1 || keycode == 14) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this.opt.slot.getGui());
            return;
        }
        super.func_73869_a(c, keycode);
    }

    public void func_73863_a(int mousex, int mousey, float f) {
        super.func_73863_a(mousex, mousey, f);
        if (this.show()) {
            HUDRenderer.renderOverlay(new ItemStack(Blocks.field_150451_bX), Arrays.asList("RedstoneBlock", EnumChatFormatting.RED + "Sample"), this.renderPos());
        }
    }

    public Point getPos() {
        return new Point(this.opt.renderTag(this.name + ".x").getIntValue(), this.opt.renderTag(this.name + ".y").getIntValue());
    }

    public Dimension sampleSize() {
        return new Dimension(101, 30);
    }

    public Point getDrag() {
        Point mouse = GuiDraw.getMousePosition();
        Point drag = new Point(mouse.x - this.dragDown.x, mouse.y - this.dragDown.y);
        Dimension size = GuiDraw.displaySize();
        Dimension sample = this.sampleSize();
        drag.x *= 10000;
        drag.y *= 10000;
        drag.x /= size.width - sample.width;
        drag.y /= size.height - sample.height;
        Point pos = this.getPos();
        drag.x = (int)MathHelper.clip((double)drag.x, (double)(-pos.x), (double)(10000 - pos.x));
        drag.y = (int)MathHelper.clip((double)drag.y, (double)(-pos.y), (double)(10000 - pos.y));
        return drag;
    }

    public Point renderPos() {
        Point pos = this.getPos();
        if (this.dragDown != null) {
            Point drag = this.getDrag();
            pos.x += drag.x;
            pos.y += drag.y;
        }
        for (int i = 25; i < 100; i += 25) {
            if (pos.x / 100 == i) {
                pos.x = i * 100;
            }
            if (pos.y / 100 != i) continue;
            pos.y = i * 100;
        }
        return pos;
    }

    protected void func_146286_b(int x, int y, int button) {
        if (button == 0 && this.dragDown != null) {
            this.setPos(this.renderPos());
            this.dragDown = null;
        }
    }

    public Rectangle4i selectionBox() {
        Point pos = this.renderPos();
        Dimension size = GuiDraw.displaySize();
        Dimension rect = this.sampleSize();
        return new Rectangle4i((size.width - rect.width) * pos.x / 10000, (size.height - rect.height) * pos.y / 10000, rect.width, rect.height);
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        if (button == 0 && this.selectionBox().contains(x, y)) {
            this.dragDown = GuiDraw.getMousePosition();
        } else {
            super.func_73864_a(x, y, button);
        }
    }

    private void setPos(Point p) {
        this.opt.getTag(this.name).setBooleanValue(this.show());
        this.opt.getTag(this.name + ".x").setIntValue(p.x);
        this.opt.getTag(this.name + ".y").setIntValue(p.y);
    }
}

