/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.ItemStackSet;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;

public class BrewingRecipeHandler
extends TemplateRecipeHandler {
    public static final ItemStackSet ingredients = new ItemStackSet();
    public static final HashSet<BrewingRecipe> apotions = new HashSet();

    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(58, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(92, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(68, 23, 28, 18), "brewing", new Object[0]));
    }

    @Override
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiBrewingStand.class;
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.brewing", new Object[0]);
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("brewing") && this.getClass() == BrewingRecipeHandler.class) {
            for (BrewingRecipe recipe : apotions) {
                this.arecipes.add(new CachedBrewingRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        if (result.func_77973_b() != Items.field_151068_bn) {
            return;
        }
        int damage = result.func_77952_i();
        for (BrewingRecipe recipe : apotions) {
            if (recipe.result.item.func_77952_i() != damage) continue;
            this.arecipes.add(new CachedBrewingRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient.func_77973_b() != Items.field_151068_bn && !ingredients.contains(ingredient)) {
            return;
        }
        for (BrewingRecipe recipe : apotions) {
            if (!NEIServerUtils.areStacksSameType(recipe.ingredient.item, ingredient) && !NEIServerUtils.areStacksSameType(recipe.precursorPotion.item, ingredient)) continue;
            this.arecipes.add(new CachedBrewingRecipe(recipe));
        }
    }

    @Override
    public String getGuiTexture() {
        return "textures/gui/container/brewing_stand.png";
    }

    @Override
    public void drawExtras(int recipe) {
        this.drawProgressBar(92, 5, 176, 0, 8, 30, 120, 1);
        this.drawProgressBar(60, 1, 185, -2, 12, 30, 35, 3);
    }

    public static void searchPotions() {
        HashSet<Integer> newPotions;
        TreeSet<Integer> allPotions = new TreeSet<Integer>();
        HashSet<Integer> searchPotions = new HashSet<Integer>();
        searchPotions.add(0);
        allPotions.add(0);
        do {
            newPotions = new HashSet<Integer>();
            for (Integer basePotion : searchPotions) {
                if (ItemPotion.func_77831_g((int)basePotion)) continue;
                for (ItemStack ingred : ingredients.values()) {
                    int result = PotionHelper.func_77913_a((int)basePotion, (String)ingred.func_77973_b().func_150896_i(ingred));
                    if (ItemPotion.func_77831_g((int)result)) {
                        BrewingRecipeHandler.addPotion(ingred, basePotion, result, allPotions, newPotions);
                        continue;
                    }
                    List baseMods = Items.field_151068_bn.func_77834_f(basePotion.intValue());
                    List newMods = Items.field_151068_bn.func_77834_f(result);
                    if (basePotion > 0 && baseMods == newMods || baseMods != null && (baseMods.equals(newMods) || newMods == null) || basePotion == result || BrewingRecipeHandler.levelModifierChanged(basePotion, result)) continue;
                    BrewingRecipeHandler.addPotion(ingred, basePotion, result, allPotions, newPotions);
                }
            }
        } while (!(searchPotions = newPotions).isEmpty());
        API.setItemListEntries((Item)Items.field_151068_bn, Iterables.transform(allPotions, (Function)new Function<Integer, ItemStack>(){

            public ItemStack apply(Integer potionID) {
                return new ItemStack((Item)Items.field_151068_bn, 1, potionID.intValue());
            }
        }));
        API.addSubset("Items.Potions", new ItemStackSet().with(new Item[]{Items.field_151068_bn}));
        API.addSubset("Items.Potions.Splash", new ItemFilter(){

            @Override
            public boolean matches(ItemStack item) {
                return item.func_77973_b() == Items.field_151068_bn && (item.func_77952_i() & 0x4000) != 0;
            }
        });
        ItemStackSet positivepots = new ItemStackSet();
        ItemStackSet negativepots = new ItemStackSet();
        ItemStackSet neutralpots = new ItemStackSet();
        Iterator<Object> i$ = allPotions.iterator();
        while (i$.hasNext()) {
            int potionID = (Integer)i$.next();
            List effectlist = Items.field_151068_bn.func_77834_f(potionID);
            int type = 0;
            if (effectlist != null && !effectlist.isEmpty()) {
                for (PotionEffect potioneffect : effectlist) {
                    if (Potion.field_76425_a[potioneffect.func_76456_a()].func_76398_f()) {
                        --type;
                        continue;
                    }
                    ++type;
                }
            }
            (type == 0 ? neutralpots : (type > 0 ? positivepots : negativepots)).add(new ItemStack((Item)Items.field_151068_bn, 1, potionID));
        }
        API.addSubset("Items.Potions.Positive", positivepots);
        API.addSubset("Items.Potions.Negative", negativepots);
        API.addSubset("Items.Potions.Neutral", neutralpots);
    }

    private static boolean levelModifierChanged(int basePotionID, int result) {
        int basemod = basePotionID & 0xE0;
        int resultmod = result & 0xE0;
        return basemod != 0 && basemod != resultmod;
    }

    private static void addPotion(ItemStack ingred, int basePotion, int result, TreeSet<Integer> allPotions, HashSet<Integer> newPotions) {
        apotions.add(new BrewingRecipe(ingred, basePotion, result));
        if (allPotions.add(result)) {
            newPotions.add(result);
        }
    }

    @Override
    public String getOverlayIdentifier() {
        return "brewing";
    }

    public class CachedBrewingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public BrewingRecipe recipe;

        public CachedBrewingRecipe(BrewingRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        public PositionedStack getResult() {
            return this.recipe.result;
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> recipestacks = new ArrayList<PositionedStack>();
            recipestacks.add(this.recipe.ingredient);
            recipestacks.add(this.recipe.precursorPotion);
            return recipestacks;
        }
    }

    public static class BrewingRecipe {
        public PositionedStack precursorPotion;
        public PositionedStack result;
        public PositionedStack ingredient;

        public BrewingRecipe(ItemStack ingred, int basePotionID, int resultDamage) {
            this.precursorPotion = new PositionedStack(new ItemStack((Item)Items.field_151068_bn, 1, basePotionID), 51, 35);
            this.ingredient = new PositionedStack(ingred, 74, 6);
            this.result = new PositionedStack(new ItemStack((Item)Items.field_151068_bn, 1, resultDamage), 97, 35);
        }
    }
}

