/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.core.CommonUtils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemPanel;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.config.Option;
import codechicken.nei.guihook.GuiContainerManager;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GuiItemIconDumper
extends GuiScreen {
    static final int[] illegalChars = new int[]{34, 60, 62, 124, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 58, 42, 63, 92, 47};
    private Option opt;
    private int drawIndex;
    private int parseIndex;
    private File dir = new File(CommonUtils.getMinecraftDir(), "dumps/itempanel_icons");
    private int iconSize;
    private int borderSize;
    private int boxSize;
    private IntBuffer pixelBuffer;
    private int[] pixelValues;

    public GuiItemIconDumper(Option opt, int iconSize) {
        this.opt = opt;
        this.iconSize = iconSize;
        this.borderSize = iconSize / 16;
        this.boxSize = iconSize + this.borderSize * 2;
        if (this.dir.exists()) {
            for (File f : this.dir.listFiles()) {
                if (!f.isFile()) continue;
                f.delete();
            }
        } else {
            this.dir.mkdirs();
        }
    }

    private void returnScreen(IChatComponent msg) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.opt.slot.getGui());
        NEIClientUtils.printChatMessage(msg);
    }

    protected void func_73869_a(char c, int keycode) throws IOException {
        if (keycode == 1 || keycode == 14) {
            this.returnScreen((IChatComponent)new ChatComponentTranslation(this.opt.fullName() + ".icon.cancelled", new Object[0]));
            return;
        }
        super.func_73869_a(c, keycode);
    }

    public void func_73863_a(int mousex, int mousey, float frame) {
        try {
            this.drawItems();
            this.exportItems();
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error dumping item icons", (Throwable)e);
        }
    }

    private void drawItems() {
        Dimension d = GuiDraw.displayRes();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)((double)d.width * 16.0 / (double)this.iconSize), (double)((double)d.height * 16.0 / (double)this.iconSize), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179086_m((int)16640);
        int rows = d.height / this.boxSize;
        int cols = d.width / this.boxSize;
        int fit = rows * cols;
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; this.drawIndex < ItemPanel.items.size() && i < fit; ++i) {
            int x = i % cols * 18;
            int y = i / cols * 18;
            GuiContainerManager.drawItem(x + 1, y + 1, ItemPanel.items.get(this.drawIndex));
            ++this.drawIndex;
        }
        GL11.glFlush();
    }

    private void exportItems() throws IOException {
        BufferedImage img = this.screenshot();
        int rows = img.getHeight() / this.boxSize;
        int cols = img.getWidth() / this.boxSize;
        int fit = rows * cols;
        for (int i = 0; this.parseIndex < ItemPanel.items.size() && i < fit; ++i) {
            int x = i % cols * this.boxSize;
            int y = i / cols * this.boxSize;
            this.exportImage(this.dir, img.getSubimage(x + this.borderSize, y + this.borderSize, this.iconSize, this.iconSize), ItemPanel.items.get(this.parseIndex));
            ++this.parseIndex;
        }
        if (this.parseIndex >= ItemPanel.items.size()) {
            this.returnScreen((IChatComponent)new ChatComponentTranslation(this.opt.fullName() + ".icon.dumped", new Object[]{"dumps/itempanel_icons"}));
        }
    }

    public static String cleanFileName(String name) {
        StringBuilder cleanName = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Arrays.binarySearch(illegalChars, (int)c) < 0) {
                cleanName.append(c);
                continue;
            }
            cleanName.append('_');
        }
        return cleanName.toString();
    }

    private void exportImage(File dir, BufferedImage img, ItemStack stack) throws IOException {
        String name = EnumChatFormatting.func_110646_a((String)GuiContainerManager.itemDisplayNameShort(stack));
        name = GuiItemIconDumper.cleanFileName(name);
        File file = new File(dir, name + ".png");
        int i = 2;
        while (file.exists()) {
            file = new File(dir, name + '_' + i + ".png");
            ++i;
        }
        ImageIO.write((RenderedImage)img, "png", file);
    }

    private BufferedImage screenshot() {
        Dimension mcSize;
        Framebuffer fb = Minecraft.func_71410_x().func_147110_a();
        Dimension texSize = mcSize = GuiDraw.displayRes();
        if (OpenGlHelper.func_148822_b()) {
            texSize = new Dimension(fb.field_147622_a, fb.field_147620_b);
        }
        int k = texSize.width * texSize.height;
        if (this.pixelBuffer == null || this.pixelBuffer.capacity() < k) {
            this.pixelBuffer = BufferUtils.createIntBuffer((int)k);
            this.pixelValues = new int[k];
        }
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        this.pixelBuffer.clear();
        if (OpenGlHelper.func_148822_b()) {
            GlStateManager.func_179144_i((int)fb.field_147617_g);
            GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)this.pixelBuffer);
        } else {
            GL11.glReadPixels((int)0, (int)0, (int)texSize.width, (int)texSize.height, (int)32993, (int)33639, (IntBuffer)this.pixelBuffer);
        }
        this.pixelBuffer.get(this.pixelValues);
        TextureUtil.func_147953_a((int[])this.pixelValues, (int)texSize.width, (int)texSize.height);
        BufferedImage img = new BufferedImage(mcSize.width, mcSize.height, 2);
        if (OpenGlHelper.func_148822_b()) {
            int yOff = texSize.height - mcSize.height;
            for (int y = 0; y < mcSize.height; ++y) {
                for (int x = 0; x < mcSize.width; ++x) {
                    img.setRGB(x, y, this.pixelValues[(y + yOff) * texSize.width + x]);
                }
            }
        } else {
            img.setRGB(0, 0, texSize.width, this.field_146295_m, this.pixelValues, 0, texSize.width);
        }
        return img;
    }

    static {
        Arrays.sort(illegalChars);
    }
}

