/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.packet.PacketCustom;
import codechicken.nei.NEIActions;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.PlayerSave;
import codechicken.nei.network.NEIServerPacketHandler;
import codechicken.nei.util.NEIServerUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ServerHandler {
    private static ServerHandler instance;

    public static void init() {
        instance = new ServerHandler();
        PacketCustom.assignHandler((Object)"NEI", (PacketCustom.ICustomPacketHandler)new NEIServerPacketHandler());
        MinecraftForge.EVENT_BUS.register((Object)instance);
        Item.func_150898_a((Block)Blocks.field_150474_ac).func_77627_a(true);
        NEIActions.init();
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.world.field_72995_K && NEIServerConfig.dimTags.containsKey(event.world.field_73011_w.getDimension())) {
            this.processDisabledProperties(event.world);
        }
    }

    @SubscribeEvent
    public void loadEvent(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            NEIServerConfig.load(event.getWorld());
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            PlayerSave save = NEIServerConfig.forPlayer(player.func_70005_c_());
            if (save == null) {
                return;
            }
            this.updateMagneticPlayer(player, save);
            save.updateOpChange();
            save.save();
        }
    }

    private void processDisabledProperties(World world) {
        NEIServerUtils.advanceDisabledTimes(world);
        if (NEIServerUtils.isRaining(world) && NEIServerConfig.isActionDisabled(world.field_73011_w.getDimension(), "rain")) {
            NEIServerUtils.toggleRaining(world, false);
        }
    }

    private void updateMagneticPlayer(EntityPlayerMP player, PlayerSave save) {
        if (!save.isActionEnabled("magnet") || player.field_70128_L) {
            return;
        }
        float distancexz = 16.0f;
        float distancey = 8.0f;
        double maxspeedxz = 0.5;
        double maxspeedy = 0.5;
        double speedxz = 0.05;
        double speedy = 0.07;
        List items = player.field_70170_p.func_72872_a(EntityItem.class, player.func_174813_aQ().func_72314_b((double)distancexz, (double)distancey, (double)distancexz));
        for (EntityItem item : items) {
            if (item.func_174874_s() || !NEIServerUtils.canItemFitInInventory((EntityPlayer)player, item.func_92059_d())) continue;
            if (save.magneticItems.add(item)) {
                NEIServerPacketHandler.sendAddMagneticItemTo(player, item);
            }
            double dx = player.field_70165_t - item.field_70165_t;
            double dy = player.field_70163_u + (double)player.func_70047_e() - item.field_70163_u;
            double dz = player.field_70161_v - item.field_70161_v;
            double absxz = Math.sqrt(dx * dx + dz * dz);
            double absy = Math.abs(dy);
            if (absxz > (double)distancexz) continue;
            if (absxz < 1.0) {
                item.func_70100_b_((EntityPlayer)player);
            }
            if (absxz > 1.0) {
                dx /= absxz;
                dz /= absxz;
            }
            if (absy > 1.0) {
                dy /= absy;
            }
            double vx = item.field_70159_w + speedxz * dx;
            double vy = item.field_70181_x + speedy * dy;
            double vz = item.field_70179_y + speedxz * dz;
            double absvxz = Math.sqrt(vx * vx + vz * vz);
            double absvy = Math.abs(vy);
            double rationspeedxz = absvxz / maxspeedxz;
            if (rationspeedxz > 1.0) {
                vx /= rationspeedxz;
                vz /= rationspeedxz;
            }
            double rationspeedy = absvy / maxspeedy;
            if (absvy > 1.0) {
                vy /= rationspeedy;
            }
            item.field_70159_w = vx;
            item.field_70181_x = vy;
            item.field_70179_y = vz;
        }
    }

    @SubscribeEvent
    public void loginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        NEIServerConfig.loadPlayer(event.player);
        NEIServerPacketHandler.sendHasServerSideTo((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void logoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        NEIServerConfig.unloadPlayer(event.player);
    }

    @SubscribeEvent
    public void dimChangeEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        NEIServerConfig.forPlayer(event.player.func_70005_c_()).onWorldReload();
    }

    @SubscribeEvent
    public void loginEvent(PlayerEvent.PlayerRespawnEvent event) {
        NEIServerConfig.forPlayer(event.player.func_70005_c_()).onWorldReload();
    }
}

