/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ItemSorter;
import codechicken.nei.RestartableTask;
import codechicken.nei.ThreadOperationTimer;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.util.LogHelper;
import codechicken.nei.util.NEIServerUtils;
import codechicken.nei.widget.ItemPanel;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemList {
    public static volatile List<ItemStack> items = new ArrayList<ItemStack>();
    public static volatile ListMultimap<Item, ItemStack> itemMap = ArrayListMultimap.create();
    public static final List<ItemFilter.ItemFilterProvider> itemFilterers = new LinkedList<ItemFilter.ItemFilterProvider>();
    public static final List<ItemsLoadedCallback> loadCallbacks = new LinkedList<ItemsLoadedCallback>();
    private static HashSet<Item> erroredItems = new HashSet();
    private static HashSet<String> stackTraces = new HashSet();
    public static final RestartableTask loadItems = new RestartableTask("NEI Item Loading"){

        private void damageSearch(Item item, List<ItemStack> permutations) {
            HashSet<String> damageIconSet = new HashSet<String>();
            for (int damage = 0; damage < 16; ++damage) {
                try {
                    ItemStack stack = new ItemStack(item, 1, damage);
                    IBakedModel model = GuiContainerManager.drawItems.func_175037_a().func_178089_a(stack);
                    String name = GuiContainerManager.concatenatedDisplayName(stack, false);
                    String s = name + "@" + (model == null ? 0 : model.hashCode());
                    if (damageIconSet.contains(s)) continue;
                    damageIconSet.add(s);
                    permutations.add(stack);
                    continue;
                }
                catch (ThreadOperationTimer.TimeoutException t) {
                    throw t;
                }
                catch (Throwable t) {
                    NEIServerUtils.logOnce(t, stackTraces, "Ommiting " + item + ":" + damage + " " + item.getClass().getSimpleName(), item.toString());
                }
            }
        }

        @Override
        public void execute() {
            ThreadOperationTimer timer = this.getTimer(500);
            LinkedList<ItemStack> items = new LinkedList<ItemStack>();
            LinkedList<ItemStack> permutations = new LinkedList<ItemStack>();
            ArrayListMultimap itemMap = ArrayListMultimap.create();
            timer.setLimit(500);
            for (Item item : Item.field_150901_e) {
                if (this.interrupted()) {
                    return;
                }
                if (item == null || erroredItems.contains(item)) continue;
                try {
                    timer.reset(item);
                    permutations.clear();
                    permutations.addAll(ItemInfo.itemOverrides.get((Object)item));
                    if (permutations.isEmpty()) {
                        item.func_150895_a(item, null, permutations);
                    }
                    if (permutations.isEmpty()) {
                        this.damageSearch(item, permutations);
                    }
                    permutations.addAll(ItemInfo.itemVariants.get((Object)item));
                    timer.reset();
                    items.addAll(permutations);
                    itemMap.putAll((Object)item, permutations);
                }
                catch (Throwable t) {
                    LogHelper.errorError("Removing item: %s from list.", t, item);
                    erroredItems.add(item);
                }
            }
            if (this.interrupted()) {
                return;
            }
            ItemList.items = items;
            ItemList.itemMap = itemMap;
            for (ItemsLoadedCallback callback : loadCallbacks) {
                callback.itemsLoaded();
            }
            updateFilter.restart();
        }
    };
    public static final RestartableTask updateFilter = new RestartableTask("NEI Item Filtering"){

        @Override
        public void execute() {
            ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
            ItemFilter filter = ItemList.getItemListFilter();
            for (ItemStack item : items) {
                if (this.interrupted()) {
                    return;
                }
                if (!filter.matches(item)) continue;
                filtered.add(item);
            }
            if (this.interrupted()) {
                return;
            }
            ItemSorter.sort(filtered);
            if (this.interrupted()) {
                return;
            }
            ItemPanel.updateItemList(filtered);
        }
    };

    public static boolean itemMatchesAll(ItemStack item, List<ItemFilter> filters) {
        for (ItemFilter filter : filters) {
            try {
                if (filter.matches(item)) continue;
                return false;
            }
            catch (Exception e) {
                LogHelper.errorError("Exception filtering " + item + " with " + filter, e);
            }
        }
        return true;
    }

    @Deprecated
    public static boolean itemMatches(ItemStack item) {
        return ItemList.getItemListFilter().matches(item);
    }

    public static ItemFilter getItemListFilter() {
        return new AllMultiItemFilter(ItemList.getItemFilters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ItemFilter> getItemFilters() {
        LinkedList<ItemFilter> filters = new LinkedList<ItemFilter>();
        List<ItemFilter.ItemFilterProvider> list = itemFilterers;
        synchronized (list) {
            for (ItemFilter.ItemFilterProvider p : itemFilterers) {
                filters.add(p.getFilter());
            }
        }
        return filters;
    }

    public static interface ItemsLoadedCallback {
        public void itemsLoaded();
    }

    public static class AnyMultiItemFilter
    implements ItemFilter {
        public List<ItemFilter> filters = new LinkedList<ItemFilter>();

        public AnyMultiItemFilter(List<ItemFilter> filters) {
            this.filters = filters;
        }

        public AnyMultiItemFilter() {
            this(new LinkedList<ItemFilter>());
        }

        @Override
        public boolean matches(ItemStack item) {
            for (ItemFilter filter : this.filters) {
                try {
                    if (!filter.matches(item)) continue;
                    return true;
                }
                catch (Exception e) {
                    LogHelper.errorError("Exception filtering " + item + " with " + filter, e);
                }
            }
            return false;
        }
    }

    public static class AllMultiItemFilter
    implements ItemFilter {
        public List<ItemFilter> filters = new LinkedList<ItemFilter>();

        public AllMultiItemFilter(List<ItemFilter> filters) {
            this.filters = filters;
        }

        public AllMultiItemFilter() {
            this(new LinkedList<ItemFilter>());
        }

        @Override
        public boolean matches(ItemStack item) {
            for (ItemFilter filter : this.filters) {
                try {
                    if (filter.matches(item)) continue;
                    return false;
                }
                catch (Exception e) {
                    LogHelper.errorError("Exception filtering " + item + " with " + filter, e);
                }
            }
            return true;
        }
    }

    public static class PatternItemFilter
    implements ItemFilter {
        public Pattern pattern;

        public PatternItemFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(ItemStack item) {
            return this.pattern.matcher(ItemInfo.getSearchName(item)).find();
        }
    }

    public static class NothingItemFilter
    implements ItemFilter {
        @Override
        public boolean matches(ItemStack item) {
            return false;
        }
    }

    public static class EverythingItemFilter
    implements ItemFilter {
        @Override
        public boolean matches(ItemStack item) {
            return true;
        }
    }
}

