/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.LayoutManager;
import codechicken.nei.config.Option;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class OptionStringSet
extends Option {
    public LinkedList<String> options = new LinkedList();
    public Multimap<String, String> dependants = ArrayListMultimap.create();
    public Map<String, String> dependancies = new HashMap<String, String>();
    public Multimap<String, String> groups = ArrayListMultimap.create();

    public OptionStringSet(String name) {
        super(name);
    }

    public void addDep(String base, String dep) {
        this.dependants.put((Object)dep, (Object)base);
        this.dependancies.put(base, dep);
    }

    @Override
    public void draw(int mousex, int mousey, float frame) {
        this.drawPrefix();
        this.drawButtons();
        this.drawIcons();
    }

    public void drawPrefix() {
        GuiDraw.drawString((String)this.translateN(this.name, new Object[0]), (int)10, (int)6, (int)-1);
    }

    public void drawButtons() {
        int x = this.buttonX();
        List<String> values = this.values();
        for (String option : this.options) {
            LayoutManager.drawButtonBackground(x, 0, 20, 20, true, values.contains(option) ? 1 : 0);
            x += 24;
        }
    }

    public abstract void drawIcons();

    @Override
    public List<String> handleTooltip(int mousex, int mousey, List<String> currenttip) {
        if (new Rectangle4i(4, 4, 50, 20).contains(mousex, mousey)) {
            currenttip.add(this.translateN(this.name + ".tip", new Object[0]));
        }
        int x = this.buttonX();
        for (String option : this.options) {
            if (new Rectangle4i(x, 0, 20, 20).contains(mousex, mousey)) {
                currenttip.add(this.translateN(this.name + "." + option, new Object[0]));
            }
            x += 24;
        }
        return currenttip;
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        if (this.clickButton(x, y, button)) {
            OptionStringSet.playClickSound();
        }
    }

    public boolean clickButton(int mousex, int mousey, int button) {
        int x = this.buttonX();
        List<String> values = this.values();
        for (int i = 0; i < this.options.size(); ++i) {
            if (new Rectangle4i(x, 0, 20, 20).contains(mousex, mousey)) {
                String s = this.options.get(i);
                boolean set = values.contains(s);
                if (button == 0 && !set) {
                    this.setValue(s);
                    return true;
                }
                if (button == 1 && set) {
                    this.remValue(s);
                    return true;
                }
                return false;
            }
            x += 24;
        }
        return false;
    }

    public void setValue(String s) {
        if (this.values().contains(s)) {
            return;
        }
        String dep = this.dependancies.get(s);
        if (dep != null) {
            this.setValue(dep);
        }
        if (this.groups.containsKey((Object)s)) {
            for (String grp : this.groups.get((Object)s)) {
                this.setValue(grp);
            }
        } else {
            LinkedList<String> setUtils = new LinkedList<String>(this.values());
            setUtils.add(s);
            this.setValues(setUtils);
        }
    }

    public void remValue(String s) {
        for (String dep : this.dependants.get((Object)s)) {
            this.remValue(dep);
        }
        if (this.groups.containsKey((Object)s)) {
            for (String grp : this.groups.get((Object)s)) {
                this.remValue(grp);
            }
        } else {
            LinkedList<String> values = new LinkedList<String>(this.values());
            values.remove(s);
            this.setValues(values);
        }
    }

    public void setValues(List<String> values) {
        StringBuilder sb = new StringBuilder();
        for (String s : values) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        this.getTag().setValue(sb.toString());
    }

    public List<String> values() {
        return Arrays.asList(this.renderTag().getValue().replace(" ", "").split(","));
    }

    public int buttonX() {
        return this.slot.slotWidth() - (24 * this.options.size() - 4);
    }
}

