/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.ItemStackSet;
import codechicken.nei.api.API;
import codechicken.nei.api.stack.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import codechicken.nei.recipe.potion.IPotionRecipe;
import codechicken.nei.recipe.potion.PotionRecipeHelper;
import codechicken.nei.util.NEIClientUtils;
import codechicken.nei.util.NEIServerUtils;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraftforge.common.brewing.AbstractBrewingRecipe;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class BrewingRecipeHandler
extends TemplateRecipeHandler {
    public static final ItemStackSet ingredients = new ItemStackSet();
    public static final HashSet<NEIBrewingRecipe> apotions = new HashSet();

    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(58, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(92, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(68, 23, 28, 18), "brewing", new Object[0]));
    }

    @Override
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiBrewingStand.class;
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.brewing", new Object[0]);
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("brewing") && this.getClass() == BrewingRecipeHandler.class) {
            for (NEIBrewingRecipe nEIBrewingRecipe : apotions) {
                this.arecipes.add(new CachedBrewingRecipe(nEIBrewingRecipe));
            }
            for (IBrewingRecipe iBrewingRecipe : BrewingRecipeRegistry.getRecipes()) {
                if (!(iBrewingRecipe instanceof BrewingRecipe) && !(iBrewingRecipe instanceof BrewingOreRecipe)) continue;
                this.arecipes.add(new CachedBrewingRecipe((AbstractBrewingRecipe)iBrewingRecipe));
            }
            for (IPotionRecipe iPotionRecipe : PotionRecipeHelper.getRecipes()) {
                this.arecipes.add(new CachedBrewingRecipe(iPotionRecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        if (result.func_77973_b() == Items.field_151068_bn) {
            int damage = result.func_77952_i();
            for (NEIBrewingRecipe recipe : apotions) {
                if (recipe.output.item.func_77952_i() != damage) continue;
                this.arecipes.add(new CachedBrewingRecipe(recipe));
            }
        }
        for (IBrewingRecipe iBrewingRecipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(iBrewingRecipe instanceof BrewingRecipe) && !(iBrewingRecipe instanceof BrewingOreRecipe) || !NEIServerUtils.areStacksSameType(((AbstractBrewingRecipe)iBrewingRecipe).getOutput(), result)) continue;
            this.arecipes.add(new CachedBrewingRecipe((AbstractBrewingRecipe)iBrewingRecipe));
        }
        for (IPotionRecipe iPotionRecipe : PotionRecipeHelper.getRecipes()) {
            if (!NEIServerUtils.areStacksSameType(iPotionRecipe.getRecipeOutput(), result)) continue;
            this.arecipes.add(new CachedBrewingRecipe(iPotionRecipe));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient.func_77973_b() == Items.field_151068_bn || ingredients.contains(ingredient)) {
            for (NEIBrewingRecipe nEIBrewingRecipe : apotions) {
                if (!NEIServerUtils.areStacksSameType(nEIBrewingRecipe.ingredient.item, ingredient) && !NEIServerUtils.areStacksSameType(nEIBrewingRecipe.input.item, ingredient)) continue;
                this.arecipes.add(new CachedBrewingRecipe(nEIBrewingRecipe));
            }
        }
        block1: for (IBrewingRecipe iBrewingRecipe : BrewingRecipeRegistry.getRecipes()) {
            ItemStack[] recipeIngredients;
            if (!(iBrewingRecipe instanceof BrewingRecipe) && !(iBrewingRecipe instanceof BrewingOreRecipe)) continue;
            AbstractBrewingRecipe arecipe = (AbstractBrewingRecipe)iBrewingRecipe;
            if (NEIServerUtils.areStacksSameType(arecipe.getInput(), ingredient)) {
                this.arecipes.add(new CachedBrewingRecipe(arecipe));
                continue;
            }
            for (ItemStack recipeIngredient : recipeIngredients = NEIServerUtils.extractRecipeItems(arecipe.getIngredient())) {
                if (!NEIServerUtils.areStacksSameType(recipeIngredient, ingredient)) continue;
                this.arecipes.add(new CachedBrewingRecipe(arecipe));
                continue block1;
            }
        }
        for (IPotionRecipe iPotionRecipe : PotionRecipeHelper.getRecipes()) {
            if (NEIServerUtils.areStacksSameType(iPotionRecipe.getRecipeInput(), ingredient)) {
                this.arecipes.add(new CachedBrewingRecipe(iPotionRecipe));
                continue;
            }
            if (!NEIServerUtils.areStacksSameType(iPotionRecipe.getRecipeIngredient(), ingredient)) continue;
            this.arecipes.add(new CachedBrewingRecipe(iPotionRecipe));
        }
    }

    @Override
    public String getGuiTexture() {
        return "textures/gui/container/brewing_stand.png";
    }

    @Override
    public void drawExtras(int recipe) {
        this.drawProgressBar(92, 5, 176, 0, 8, 30, 120, 1);
        this.drawProgressBar(58, 1, 185, -2, 12, 30, 35, 3);
    }

    public static void searchPotions() {
        ArrayList<ItemStack> allPotions = new ArrayList<ItemStack>();
        for (IPotionRecipe recipe : PotionRecipeHelper.getRecipes()) {
            allPotions.add(recipe.getRecipeOutput());
        }
        ItemStackSet positiveEffects = new ItemStackSet();
        ItemStackSet negativeEffects = new ItemStackSet();
        ItemStackSet neutralEffects = new ItemStackSet();
        for (ItemStack potionStack : allPotions) {
            PotionType potionType = BrewingRecipeHandler.getPotionTypeFromStack(potionStack);
            if (potionType == null) continue;
            List stackEffects = potionType.func_185170_a();
            if (stackEffects.isEmpty()) {
                neutralEffects.add(potionStack);
                continue;
            }
            for (PotionEffect effect : stackEffects) {
                if (effect.func_188419_a().func_76398_f()) {
                    if (negativeEffects.contains(potionStack)) continue;
                    negativeEffects.add(potionStack);
                    continue;
                }
                if (positiveEffects.contains(potionStack)) continue;
                positiveEffects.add(potionStack);
            }
        }
        API.addSubset("Items.Potions", new ItemStackSet().with(new Item[]{Items.field_151068_bn}).with(new Item[]{Items.field_185155_bH}).with(new Item[]{Items.field_185156_bI}));
        API.addSubset("Items.Potions.Splash", new ItemStackSet().with(new Item[]{Items.field_185155_bH}));
        API.addSubset("Items.Potions.Lingering", new ItemStackSet().with(new Item[]{Items.field_185156_bI}));
        API.addSubset("Items.Potions.Positive", positiveEffects);
        API.addSubset("Items.Potions.Negative", negativeEffects);
        API.addSubset("Items.Potions.Neutral", neutralEffects);
    }

    @Override
    public String getOverlayIdentifier() {
        return "brewing";
    }

    private static PotionType getPotionTypeFromStack(ItemStack itemStack) {
        String potion;
        PotionType type;
        NBTTagCompound tagCompound;
        if (itemStack.func_77942_o() && (tagCompound = itemStack.func_77978_p()).func_74764_b("Potion") && (type = PotionType.func_185168_a((String)(potion = tagCompound.func_74779_i("Potion")))) != null) {
            return type;
        }
        return null;
    }

    public class CachedBrewingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        final NEIBrewingRecipe recipe;

        public CachedBrewingRecipe(NEIBrewingRecipe recipe) {
            super(BrewingRecipeHandler.this);
            this.recipe = recipe;
        }

        public CachedBrewingRecipe(AbstractBrewingRecipe<?> recipe) {
            this(new NEIBrewingRecipe(recipe));
        }

        public CachedBrewingRecipe(IPotionRecipe recipe) {
            this(new NEIBrewingRecipe(recipe));
        }

        @Override
        public PositionedStack getResult() {
            return this.recipe.output;
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> recipestacks = new ArrayList<PositionedStack>();
            recipestacks.add(this.recipe.ingredient);
            recipestacks.add(this.recipe.input);
            return recipestacks;
        }
    }

    public static class NEIBrewingRecipe {
        final PositionedStack input;
        final PositionedStack output;
        final PositionedStack ingredient;

        public NEIBrewingRecipe(AbstractBrewingRecipe<?> recipe) {
            this.input = new PositionedStack(recipe.getInput(), 51, 40);
            this.output = new PositionedStack(recipe.getOutput(), 97, 40);
            this.ingredient = new PositionedStack(recipe.getIngredient(), 74, 6);
        }

        public NEIBrewingRecipe(IPotionRecipe recipe) {
            this.input = new PositionedStack(recipe.getRecipeInput(), 51, 40);
            this.output = new PositionedStack(recipe.getRecipeOutput(), 97, 40);
            this.ingredient = new PositionedStack(recipe.getRecipeIngredient(), 74, 6);
        }
    }
}

