/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.config.DataDumper;
import codechicken.nei.config.GuiItemIconDumper;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.util.NEIClientUtils;
import codechicken.nei.widget.ItemPanel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class ItemPanelDumper
extends DataDumper {
    private static int[] resolutions = new int[]{16, 32, 48, 64, 128, 256};

    public ItemPanelDumper(String name) {
        super(name);
    }

    @Override
    public String[] header() {
        return new String[]{"Item Name", "Item ID", "Item meta", "Has NBT", "Display Name"};
    }

    @Override
    public Iterable<String[]> dump(int mode) {
        LinkedList<String[]> list = new LinkedList<String[]>();
        for (ItemStack stack : ItemPanel.items) {
            list.add(new String[]{((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString(), Integer.toString(Item.func_150891_b((Item)stack.func_77973_b())), Integer.toString(InventoryUtils.actualDamage((ItemStack)stack)), stack.func_77978_p() == null ? "false" : "true", TextFormatting.func_110646_a((String)GuiContainerManager.itemDisplayNameShort(stack))});
        }
        return list;
    }

    @Override
    public String renderName() {
        return this.translateN(this.name, new Object[0]);
    }

    public int getRes() {
        int i = this.renderTag(this.name + ".res").getIntValue(0);
        if (i >= resolutions.length || i < 0) {
            i = 0;
            this.renderTag().setIntValue(0);
        }
        return resolutions[i];
    }

    public Rectangle4i resButtonSize() {
        int width = 50;
        return new Rectangle4i(this.modeButtonSize().x - width - 6, 0, width, 20);
    }

    @Override
    public void draw(int mousex, int mousey, float frame) {
        super.draw(mousex, mousey, frame);
        if (this.getMode() == 3) {
            int res = this.getRes();
            this.drawButton(mousex, mousey, this.resButtonSize(), res + "x" + res);
        }
    }

    @Override
    public void mouseClicked(int mousex, int mousey, int button) {
        if (this.getMode() == 3 && this.resButtonSize().contains(mousex, mousey)) {
            NEIClientUtils.playClickSound();
            this.getTag(this.name + ".res").setIntValue((this.renderTag(this.name + ".res").getIntValue(0) + 1) % resolutions.length);
        } else {
            super.mouseClicked(mousex, mousey, button);
        }
    }

    @Override
    public String getFileExtension() {
        switch (this.getMode()) {
            case 0: {
                return ".csv";
            }
            case 1: {
                return ".nbt";
            }
            case 2: {
                return ".json";
            }
        }
        return null;
    }

    public TextComponentTranslation dumpMessage(File file) {
        return new TextComponentTranslation(this.namespaced(this.name + ".dumped"), new Object[]{"dumps/" + file.getName()});
    }

    @Override
    public String modeButtonText() {
        return this.translateN(this.name + ".mode." + this.getMode(), new Object[0]);
    }

    @Override
    public void dumpFile() {
        if (this.getMode() == 3) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiItemIconDumper(this, this.getRes()));
        } else {
            super.dumpFile();
        }
    }

    @Override
    public void dumpTo(File file) throws IOException {
        if (this.getMode() == 0) {
            super.dumpTo(file);
        } else if (this.getMode() == 1) {
            this.dumpNBT(file);
        } else {
            this.dumpJson(file);
        }
    }

    public void dumpNBT(File file) throws IOException {
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : ItemPanel.items) {
            list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("list", (NBTBase)list);
        CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)new FileOutputStream(file));
    }

    public void dumpJson(File file) throws IOException {
        PrintWriter p = new PrintWriter(file);
        for (ItemStack stack : ItemPanel.items) {
            NBTTagCompound tag = stack.func_77955_b(new NBTTagCompound());
            tag.func_82580_o("Count");
            p.println(tag);
        }
        p.close();
    }

    @Override
    public int modeCount() {
        return 4;
    }
}

