/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.featurehack;

import codechicken.lib.item.filtering.IItemFilter;
import codechicken.lib.thread.RestartableTask;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class VanillaCreativeTabSearchHooks {
    private static HashMap<CreativeTabs, ArrayList<ItemStack>> tabCache = new HashMap();
    public static final VanillaFilterTask filterTask = new VanillaFilterTask("NEI Vanilla creative tab filtering.");

    public static void updateSearchListThreaded(GuiContainerCreative guiContainerCreative) {
        filterTask.stop();
        filterTask.setContainerCreative((GuiContainerCreative.ContainerCreative)guiContainerCreative.field_147002_h);
        filterTask.setSearchBox(guiContainerCreative.field_147062_A);
        filterTask.setCreativeTab(CreativeTabs.field_78032_a[guiContainerCreative.func_147056_g()]);
        filterTask.restart();
    }

    private static List<ItemStack> getStacksForTab(CreativeTabs creativeTab) {
        ArrayList<ItemStack> tabStacks = new ArrayList<ItemStack>();
        if (creativeTab == CreativeTabs.field_78027_g) {
            for (Item item : Item.field_150901_e) {
                if (item == null) continue;
                item.func_150895_a(item, null, tabStacks);
            }
            for (Enchantment enchantment : Enchantment.field_185264_b) {
                if (enchantment == null || enchantment.field_77351_y == null) continue;
                Items.field_151134_bR.func_92113_a(enchantment, tabStacks);
            }
        }
        creativeTab.func_78018_a(tabStacks);
        return tabStacks;
    }

    public static class VanillaFilter
    implements IItemFilter {
        public static VanillaFilter INSTANCE = new VanillaFilter();

        public boolean matches(ItemStack item) {
            GuiTextField textField = filterTask.getSearchBox();
            if (Strings.isNullOrEmpty((String)textField.func_146179_b())) {
                return true;
            }
            if (textField.func_146179_b().toLowerCase().startsWith("@")) {
                String expectedMod = textField.func_146179_b().toLowerCase().replace("@", "");
                if (expectedMod.isEmpty()) {
                    return true;
                }
                if (item.func_77973_b().getRegistryName().func_110624_b().startsWith(expectedMod)) {
                    return true;
                }
            }
            for (String toolTipString : item.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x)) {
                if (!TextFormatting.func_110646_a((String)toolTipString).toLowerCase().contains(textField.func_146179_b().toLowerCase())) continue;
                return true;
            }
            return false;
        }
    }

    public static class VanillaFilterTask
    extends RestartableTask {
        private GuiContainerCreative.ContainerCreative containerCreative;
        private GuiTextField searchBox;
        private CreativeTabs creativeTab;

        public VanillaFilterTask(String name) {
            super(name);
        }

        public void setContainerCreative(GuiContainerCreative.ContainerCreative containerCreative) {
            this.containerCreative = containerCreative;
        }

        public void setSearchBox(GuiTextField searchBox) {
            this.searchBox = searchBox;
        }

        public void setCreativeTab(CreativeTabs creativeTab) {
            this.creativeTab = creativeTab;
        }

        public GuiTextField getSearchBox() {
            return this.searchBox;
        }

        public CreativeTabs getCreativeTab() {
            return this.creativeTab;
        }

        public void execute() {
            ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
            if (this.containerCreative == null) {
                this.stop();
            }
            VanillaFilter filter = VanillaFilter.INSTANCE;
            for (ItemStack item : VanillaCreativeTabSearchHooks.getStacksForTab(this.getCreativeTab())) {
                if (this.interrupted()) {
                    return;
                }
                if (!filter.matches(item)) continue;
                filtered.add(item);
            }
            if (this.interrupted()) {
                return;
            }
            this.containerCreative.field_148330_a = filtered;
            this.containerCreative.func_148329_a(0.0f);
        }
    }
}

