/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.layout;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.Image;
import codechicken.nei.LayoutManager;
import codechicken.nei.layout.LayoutStyleDefault;
import codechicken.nei.widget.Button;
import net.minecraft.client.renderer.GlStateManager;

public class LayoutStyleMinecraft
extends LayoutStyleDefault {
    int stateButtonCount;
    int clickButtonCount;

    @Override
    public String getName() {
        return "minecraft";
    }

    @Override
    public void init() {
        LayoutManager.delete.icon = new Image(144, 12, 12, 12);
        LayoutManager.gamemode.icons[0] = new Image(132, 12, 12, 12);
        LayoutManager.gamemode.icons[1] = new Image(156, 12, 12, 12);
        LayoutManager.gamemode.icons[2] = new Image(168, 12, 12, 12);
        LayoutManager.rain.icon = new Image(120, 12, 12, 12);
        LayoutManager.magnet.icon = new Image(180, 24, 12, 12);
        LayoutManager.timeButtons[0].icon = new Image(132, 24, 12, 12);
        LayoutManager.timeButtons[1].icon = new Image(120, 24, 12, 12);
        LayoutManager.timeButtons[2].icon = new Image(144, 24, 12, 12);
        LayoutManager.timeButtons[3].icon = new Image(156, 24, 12, 12);
        LayoutManager.heal.icon = new Image(168, 24, 12, 12);
        LayoutManager.dropDown.x = 90;
    }

    @Override
    public void reset() {
        this.clickButtonCount = 0;
        this.stateButtonCount = 0;
    }

    @Override
    public void layoutButton(Button button) {
        if ((button.state & 4) != 0) {
            button.x = 6 + this.stateButtonCount * 20;
            button.y = 3;
            ++this.stateButtonCount;
        } else {
            button.x = 6 + this.clickButtonCount % 4 * 20;
            button.y = 3 + (1 + this.clickButtonCount / 4) * 18;
            ++this.clickButtonCount;
        }
        button.h = 17;
        button.w = button.contentWidth() + 6;
    }

    @Override
    public void drawButton(Button b, int mousex, int mousey) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int tex = (b.state & 3) == 2 ? 0 : ((b.state & 4) == 0 && b.contains(mousex, mousey) || (b.state & 3) == 1 ? 2 : 1);
        LayoutManager.drawButtonBackground(b.x, b.y, b.w, b.h, true, tex);
        Image icon = b.getRenderIcon();
        if (icon == null) {
            int colour = tex == 2 ? 0xFFFFA0 : (tex == 0 ? 0x601010 : 0xE0E0E0);
            GuiDraw.drawStringC((String)b.getRenderLabel(), (int)(b.x + b.w / 2), (int)(b.y + (b.h - 8) / 2), (int)colour);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int iconx = b.x + (b.w - icon.width) / 2;
            int icony = b.y + (b.h - icon.height) / 2;
            LayoutManager.drawIcon(iconx, icony, icon);
        }
    }

    @Override
    public void drawSubsetTag(String text, int x, int y, int w, int h, int state, boolean mouseover) {
        if (state == 1) {
            GlStateManager.func_179131_c((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        LayoutManager.drawButtonBackground(x, y, w, h, false, state == 0 ? 0 : 1);
        if (text != null) {
            GuiDraw.drawStringC((String)text, (int)x, (int)y, (int)w, (int)h, (int)(state == 2 ? -2039584 : -6250336));
        }
    }
}

