/*
 * Decompiled with CFR 0.152.
 */
package DITextures;

import DITextures.EnumSkinPart;
import DITextures.FileSkinRegistration;
import DITextures.JarSkinRegistration;
import DITextures.Ordering;
import DamageIndicatorsMod.DIMod;
import DamageIndicatorsMod.configuration.DIConfig;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.opengl.GL11;

public abstract class AbstractSkin {
    public static final List<String> AVAILABLESKINS = new ArrayList<String>();
    private static String lastSkinUsed;
    public static final Minecraft MCINSTANCE;
    public static final Map<String, AbstractSkin> SKINS;
    private final EnumMap<EnumSkinPart, Object> skinMap = new EnumMap(EnumSkinPart.class);

    public static BufferedImage fixDim(BufferedImage nonpoweroftwo) {
        BufferedImage resized;
        int height;
        int width;
        int scaledwidth = width = nonpoweroftwo.getWidth();
        if (!AbstractSkin.isPowerOfTwoFast(width)) {
            scaledwidth = AbstractSkin.upperPowerOfTwo(width);
        }
        int scaledheight = height = nonpoweroftwo.getHeight();
        if (!AbstractSkin.isPowerOfTwoFast(height)) {
            scaledheight = AbstractSkin.upperPowerOfTwo(height);
        }
        if (width == scaledwidth && height == scaledheight) {
            resized = nonpoweroftwo;
        } else {
            try {
                resized = new BufferedImage(scaledwidth, scaledheight, nonpoweroftwo.getType());
            }
            catch (Throwable ex) {
                resized = new BufferedImage(scaledwidth, scaledheight, 5);
            }
            Graphics2D graphics = resized.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawImage(nonpoweroftwo, 0, 0, scaledwidth, scaledheight, 0, 0, width, height, null);
            graphics.dispose();
        }
        return resized;
    }

    public static AbstractSkin getActiveSkin() {
        return AbstractSkin.setSkin(DIConfig.mainInstance().selectedSkin);
    }

    public static String getAuthor(String internalName) {
        return (String)SKINS.get(internalName).getSkinValue(EnumSkinPart.CONFIGAUTHOR);
    }

    public static String getSkinName(String internalName) {
        return (String)SKINS.get(internalName).getSkinValue(EnumSkinPart.CONFIGDISPLAYNM);
    }

    public static void init() {
        JarSkinRegistration.scanJarForSkins(DIMod.class);
        File file = new File(Minecraft.func_71410_x().field_71412_D, "CustomDISkins");
        file.mkdirs();
        FileSkinRegistration.scanFilesForSkins(file);
        for (String s : AVAILABLESKINS) {
            AbstractSkin skin = null;
            skin = s.startsWith("file:") ? new FileSkinRegistration(s) : new JarSkinRegistration(s);
            AbstractSkin.releaseCurrentTextures();
            skin.loadSkin();
            SKINS.put(s, skin);
        }
        if (!AVAILABLESKINS.contains(DIConfig.mainInstance().selectedSkin)) {
            DIConfig.mainInstance().selectedSkin = "/assets/defaultskins/default/";
            DIConfig.overrideConfigAndSave(DIConfig.mainInstance());
            AbstractSkin.setSkin(DIConfig.mainInstance().selectedSkin);
        }
        AbstractSkin.releaseCurrentTextures();
        AbstractSkin.getActiveSkin().loadSkin();
    }

    private static boolean isPowerOfTwoFast(int num) {
        return num != 0 && (num & num - 1) == 0;
    }

    public static void refreshSkin() {
        AbstractSkin.releaseCurrentTextures();
        AbstractSkin.getActiveSkin().loadSkin();
    }

    public abstract void loadConfig();

    private static void releaseCurrentTextures() {
        AbstractSkin lastSkin = SKINS.get(lastSkinUsed);
        if (lastSkin != null) {
            for (EnumSkinPart esp : EnumSet.allOf(EnumSkinPart.class)) {
                if (!esp.name().endsWith("ID") || (DynamicTexture)lastSkin.skinMap.get((Object)esp) == null) continue;
                ((DynamicTexture)lastSkin.skinMap.get((Object)esp)).func_147631_c();
                lastSkin.skinMap.put(esp, null);
            }
        }
    }

    public static AbstractSkin setSkin(String skin) {
        if (lastSkinUsed != null && !lastSkinUsed.equals(skin)) {
            AbstractSkin.releaseCurrentTextures();
            if (SKINS.containsKey(skin)) {
                SKINS.get(skin).loadSkin();
            }
        }
        if (!SKINS.containsKey(skin)) {
            try {
                if (skin.startsWith("file:")) {
                    SKINS.put(skin, new FileSkinRegistration(skin));
                } else {
                    SKINS.put(skin, new JarSkinRegistration(skin));
                }
                SKINS.get(skin).loadSkin();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        lastSkinUsed = skin;
        return SKINS.get(skin);
    }

    private static int upperPowerOfTwo(int num) {
        int newnum = num - 1;
        newnum |= newnum >> 1;
        newnum |= newnum >> 2;
        newnum |= newnum >> 4;
        newnum |= newnum >> 8;
        newnum |= newnum >> 16;
        return ++newnum;
    }

    public AbstractSkin() {
        for (EnumSkinPart esp : EnumSet.allOf(EnumSkinPart.class)) {
            this.skinMap.put(esp, esp.getConfigDefault());
        }
    }

    public String getFriendlyName(EnumSkinPart enumSkinPart) {
        switch (enumSkinPart) {
            case BACKGROUNDID: {
                return (String)this.skinMap.get((Object)EnumSkinPart.BACKGROUNDNAME);
            }
            case CENTERPOTIONID: {
                return (String)this.skinMap.get((Object)EnumSkinPart.CENTERPOTIONNAME);
            }
            case DAMAGEID: {
                return (String)this.skinMap.get((Object)EnumSkinPart.DAMAGENAME);
            }
            case FRAMEID: {
                return (String)this.skinMap.get((Object)EnumSkinPart.FRAMENAME);
            }
            case HEALTHID: {
                return (String)this.skinMap.get((Object)EnumSkinPart.HEALTHNAME);
            }
            case LEFTPOTIONID: {
                return (String)this.skinMap.get((Object)EnumSkinPart.LEFTPOTIONNAME);
            }
            case NAMEPLATEID: {
                return (String)this.skinMap.get((Object)EnumSkinPart.NAMEPLATENAME);
            }
            case RIGHTPOTIONID: {
                return (String)this.skinMap.get((Object)EnumSkinPart.RIGHTPOTIONNAME);
            }
            case TYPEICONSID: {
                return (String)this.skinMap.get((Object)EnumSkinPart.TYPEICONSNAME);
            }
        }
        return "";
    }

    public final void bindTexture(EnumSkinPart enumSkinPart) {
        DynamicTexture dt = (DynamicTexture)this.skinMap.get((Object)enumSkinPart);
        dt.func_110564_a();
        GL11.glBindTexture((int)3553, (int)dt.func_110552_b());
    }

    public final String getInternalName() {
        return (String)this.skinMap.get((Object)EnumSkinPart.INTERNAL);
    }

    public final Object getSkinValue(EnumSkinPart enumSkinPart) {
        return this.skinMap.get((Object)enumSkinPart);
    }

    protected final void loadConfig(Configuration config) {
        config.load();
        String strKey = null;
        for (EnumSkinPart enumSkinPart : EnumSet.allOf(EnumSkinPart.class)) {
            String spName = enumSkinPart.name();
            strKey = (String)enumSkinPart.getExtended();
            if (strKey == null) continue;
            Object defaultVal = enumSkinPart.getConfigDefault();
            String strCat = spName.endsWith("WIDTH") || spName.endsWith("HEIGHT") ? "Skin config.Sizes" : (spName.endsWith("X") || spName.endsWith("Y") || spName.endsWith("OFFSET") ? "Skin config.Positions" : (spName.contains("CONFIGTEXTEXT") ? "Skin config.TextSettings" : "Skin config.Info"));
            if (defaultVal instanceof Integer) {
                this.skinMap.put(enumSkinPart, (Object)config.get(strCat, strKey, ((Integer)defaultVal).intValue()).getInt(((Integer)defaultVal).intValue()));
                continue;
            }
            this.skinMap.put(enumSkinPart, (Object)config.get(strCat, strKey, (String)defaultVal).getString());
        }
        this.skinMap.put(EnumSkinPart.ORDERING, (Object)this.populateOrdering(config));
        config.save();
    }

    public abstract void loadSkin();

    private Ordering[] populateOrdering(Configuration config) {
        Ordering[] ordering = new Ordering[9];
        String strCat = "Skin config.Ordering";
        ordering[config.get((String)strCat, (String)"HealthBarOrder", (int)3).getInt((int)3) - 1] = Ordering.HEALTHBAR;
        ordering[config.get((String)strCat, (String)"FrameOrder", (int)5).getInt((int)5) - 1] = Ordering.FRAME;
        ordering[config.get((String)strCat, (String)"BackgroundOrder", (int)1).getInt((int)1) - 1] = Ordering.BACKGROUND;
        ordering[config.get((String)strCat, (String)"NamePlateOrder", (int)4).getInt((int)4) - 1] = Ordering.NAMEPLATE;
        ordering[config.get((String)strCat, (String)"MobPreviewOrder", (int)2).getInt((int)2) - 1] = Ordering.MOBPREVIEW;
        ordering[config.get((String)strCat, (String)"MobTypeOrder", (int)6).getInt((int)6) - 1] = Ordering.MOBTYPES;
        ordering[config.get((String)strCat, (String)"PotionBoxOrder", (int)7).getInt((int)7) - 1] = Ordering.POTIONS;
        ordering[config.get((String)strCat, (String)"HealthBarTextOrder", (int)8).getInt((int)8) - 1] = Ordering.HEALTHTEXT;
        ordering[config.get((String)strCat, (String)"NamePlateTextOrder", (int)9).getInt((int)9) - 1] = Ordering.NAMETEXT;
        return ordering;
    }

    public final void setInternalName(String newInternalName) {
        this.skinMap.put(EnumSkinPart.INTERNAL, (Object)newInternalName);
    }

    public final void setSkinValue(EnumSkinPart enumSkinPart, Object value) {
        this.skinMap.put(enumSkinPart, value);
    }

    public final DynamicTexture setupTexture(BufferedImage bufImg, EnumSkinPart uniqueName) {
        DynamicTexture check = (DynamicTexture)this.skinMap.get((Object)uniqueName);
        if (check == null) {
            check = new DynamicTexture(bufImg);
            this.skinMap.put(uniqueName, (Object)check);
        }
        bufImg.getRGB(0, 0, bufImg.getWidth(), bufImg.getHeight(), check.func_110565_c(), 0, bufImg.getWidth());
        return check;
    }

    static {
        MCINSTANCE = Minecraft.func_71410_x();
        SKINS = new HashMap<String, AbstractSkin>();
    }
}

