/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.airbreathercore.mod;

import airbreather.mods.airbreathercore.CustomConfiguration;
import airbreather.mods.airbreathercore.event.EventConfiguration;
import airbreather.mods.airbreathercore.event.EventSubscriber;
import airbreather.mods.airbreathercore.event.EventType;
import airbreather.mods.airbreathercore.item.ItemConfiguration;
import airbreather.mods.airbreathercore.item.ItemDefinition;
import airbreather.mods.airbreathercore.item.ItemRegistrar;
import airbreather.mods.airbreathercore.item.ItemRegistry;
import airbreather.mods.airbreathercore.mod.HackTextureRegistry;
import airbreather.mods.airbreathercore.mod.IModLifecycleManager;
import airbreather.mods.airbreathercore.mod.IModule;
import airbreather.mods.airbreathercore.recipe.RecipeConfiguration;
import airbreather.mods.airbreathercore.recipe.RecipeRegistrar;
import com.google.common.base.Preconditions;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.relauncher.Side;

public final class ModLifecycleManager
implements IModLifecycleManager {
    private final ItemRegistry itemRegistry;
    private final ItemRegistrar itemRegistrar;
    private final RecipeRegistrar recipeRegistrar;
    private final EventSubscriber eventSubscriber;
    private final CustomConfiguration configuration;

    public ModLifecycleManager(IModule module) {
        Preconditions.checkNotNull((Object)module, (Object)"module");
        this.itemRegistry = module.GetItemRegistry();
        this.itemRegistrar = module.GetItemRegistrar();
        this.recipeRegistrar = module.GetRecipeRegistrar();
        this.eventSubscriber = module.GetEventSubscriber();
        this.configuration = module.GetCustomConfiguration();
    }

    @Override
    public void OnPreInit(FMLPreInitializationEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
        this.configuration.Initialize(event.getSuggestedConfigurationFile());
        ItemConfiguration itemConfiguration = this.configuration.GetItemConfiguration();
        this.itemRegistrar.RegisterNewItems(itemConfiguration, this.itemRegistry);
        this.eventSubscriber.Initialize();
        EventConfiguration eventConfiguration = this.configuration.GetEventConfiguration();
        for (EventType eventType : eventConfiguration.GetRecognizedEventTypes()) {
            for (IEventListener handler : eventConfiguration.GetEventHandlers(eventType)) {
                this.eventSubscriber.SubscribeToEvent(eventType, handler);
            }
        }
    }

    @Override
    public void OnInit(FMLInitializationEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
        RecipeConfiguration recipeConfiguration = this.configuration.GetRecipeConfiguration();
        this.recipeRegistrar.RegisterRecipes(recipeConfiguration, this.itemRegistry);
        if (event.getSide() == Side.CLIENT) {
            ItemConfiguration itemConfiguration = this.configuration.GetItemConfiguration();
            for (ItemDefinition itemDefinition : itemConfiguration.GetItemDefinitionsForNewItems()) {
                Item item = this.itemRegistry.FetchItem(itemDefinition);
                HackTextureRegistry.RegisterTexture(itemDefinition, item);
            }
        }
    }

    @Override
    public void OnPostInit(FMLPostInitializationEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
    }
}

