/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.airbreathercore.event;

import airbreather.mods.airbreathercore.event.EventSubscriber;
import airbreather.mods.airbreathercore.event.EventType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class ForgeEventSubscriber
implements EventSubscriber {
    private final ListMultimap<EventType, IEventListener> eventListenerMap = ArrayListMultimap.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void SubscribeToEvent(EventType eventType, IEventListener handler) {
        Preconditions.checkNotNull((Object)handler, (Object)"handler");
        ListMultimap<EventType, IEventListener> listMultimap = this.eventListenerMap;
        synchronized (listMultimap) {
            this.eventListenerMap.put((Object)eventType, (Object)handler);
        }
    }

    @Override
    public void Initialize() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void OnLivingDropsEvent(LivingDropsEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
        for (IEventListener handler : this.eventListenerMap.get((Object)EventType.LivingDrops)) {
            handler.invoke((Event)event);
        }
    }

    @SubscribeEvent
    public void OnLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
        for (IEventListener handler : this.eventListenerMap.get((Object)EventType.LivingUpdate)) {
            handler.invoke((Event)event);
        }
    }

    @SubscribeEvent
    public void OnEntityConstructingEvent(EntityEvent.EntityConstructing event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
        for (IEventListener handler : this.eventListenerMap.get((Object)EventType.EntityConstructing)) {
            handler.invoke((Event)event);
        }
    }
}

