/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.airbreathercore.item;

import airbreather.mods.airbreathercore.item.ItemConfiguration;
import airbreather.mods.airbreathercore.item.ItemDefinition;
import airbreather.mods.airbreathercore.item.ItemRegistrar;
import airbreather.mods.airbreathercore.item.ItemRegistry;
import com.google.common.base.Preconditions;
import net.minecraft.item.Item;

public class ItemRegistrarBase
implements ItemRegistrar {
    @Override
    public final void RegisterNewItems(ItemConfiguration configuration, ItemRegistry registry) {
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        Preconditions.checkNotNull((Object)registry, (Object)"registry");
        for (ItemDefinition itemDefinition : configuration.GetItemDefinitionsForNewItems()) {
            Item item;
            if (itemDefinition == null || (item = this.CreateItem(itemDefinition)) == null) continue;
            registry.RegisterNewItem(itemDefinition, item);
            this.AfterItemRegistered(itemDefinition, item, registry);
        }
    }

    protected Item CreateItemCore(ItemDefinition definition) {
        Preconditions.checkNotNull((Object)definition, (Object)"definition");
        Preconditions.checkArgument((boolean)false, (String)"%s is not a recognized item definition.", (Object[])new Object[]{definition});
        return null;
    }

    protected void AfterItemRegistered(ItemDefinition definition, Item item, ItemRegistry registry) {
    }

    private Item CreateItem(ItemDefinition itemDefinition) {
        Preconditions.checkNotNull((Object)itemDefinition, (Object)"itemDefinition");
        Item item = this.CreateItemCore(itemDefinition);
        String itemName = itemDefinition.GetItemName();
        item.func_77655_b(itemName);
        return item;
    }
}

