/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.airbreathercore.recipe;

import airbreather.mods.airbreathercore.item.ItemDefinition;
import airbreather.mods.airbreathercore.item.ItemRegistry;
import airbreather.mods.airbreathercore.recipe.Recipe;
import airbreather.mods.airbreathercore.recipe.RecipeConfiguration;
import airbreather.mods.airbreathercore.recipe.RecipeRegistrar;
import airbreather.mods.airbreathercore.recipe.RecipeResult;
import airbreather.mods.airbreathercore.recipe.ShapedCraftingRecipe;
import airbreather.mods.airbreathercore.recipe.ShapelessCraftingRecipe;
import airbreather.mods.airbreathercore.recipe.SmeltingRecipe;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class FmlRecipeRegistrar
implements RecipeRegistrar {
    @Override
    public void RegisterRecipes(RecipeConfiguration recipeConfiguration, ItemRegistry itemRegistry) {
        Preconditions.checkNotNull((Object)recipeConfiguration, (Object)"recipeConfiguration");
        Preconditions.checkNotNull((Object)itemRegistry, (Object)"itemRegistry");
        for (Recipe recipe : recipeConfiguration.GetRecipes()) {
            switch (recipe.GetRecipeType()) {
                case Smelting: {
                    FmlRecipeRegistrar.RegisterSmeltingRecipe(recipe, itemRegistry);
                    break;
                }
                case ShapedCrafting: {
                    FmlRecipeRegistrar.RegisterShapedCraftingRecipe(recipe, itemRegistry);
                    break;
                }
                case ShapelessCrafting: {
                    FmlRecipeRegistrar.RegisterShapelessCraftingRecipe(recipe, itemRegistry);
                }
            }
        }
    }

    private static void RegisterSmeltingRecipe(Recipe recipe, ItemRegistry itemRegistry) {
        Preconditions.checkArgument((boolean)(recipe instanceof SmeltingRecipe), (String)"recipe must be a SmeltingRecipe, not %s, if GetRecipeType() returns Smelting.", (Object[])new Object[]{recipe.getClass()});
        SmeltingRecipe smeltingRecipe = (SmeltingRecipe)recipe;
        ItemDefinition inputDefinition = smeltingRecipe.GetInput();
        Item input = itemRegistry.FetchItem(inputDefinition);
        RecipeResult result = smeltingRecipe.GetResult();
        ItemStack resultItemStack = FmlRecipeRegistrar.GetResultItemStack(result, itemRegistry);
        float experience = smeltingRecipe.GetExperience();
        GameRegistry.addSmelting((Item)input, (ItemStack)resultItemStack, (float)experience);
    }

    private static void RegisterShapedCraftingRecipe(Recipe recipe, ItemRegistry itemRegistry) {
        Preconditions.checkArgument((boolean)(recipe instanceof ShapedCraftingRecipe), (String)"recipe must be a ShapedCraftingRecipe, not %s, if GetRecipeType() returns ShapedCrafting.", (Object[])new Object[]{recipe.getClass()});
        ShapedCraftingRecipe shapedCraftingRecipe = (ShapedCraftingRecipe)recipe;
        Object[] inputs = (Object[])shapedCraftingRecipe.GetInputs().clone();
        for (int i = 0; i < inputs.length; ++i) {
            Object input = inputs[i];
            if (!(input instanceof ItemDefinition)) continue;
            ItemDefinition definition = (ItemDefinition)input;
            Item item = itemRegistry.FetchItem(definition);
            inputs[i] = item;
        }
        RecipeResult result = shapedCraftingRecipe.GetResult();
        ItemStack resultItemStack = FmlRecipeRegistrar.GetResultItemStack(result, itemRegistry);
        GameRegistry.addRecipe((ItemStack)resultItemStack, (Object[])inputs);
    }

    private static void RegisterShapelessCraftingRecipe(Recipe recipe, ItemRegistry itemRegistry) {
        Preconditions.checkArgument((boolean)(recipe instanceof ShapelessCraftingRecipe), (String)"recipe must be a ShapelessCraftingRecipe, not %s, if GetRecipeType() returns ShapelessCrafting.", (Object[])new Object[]{recipe.getClass()});
        ShapelessCraftingRecipe shapelessCraftingRecipe = (ShapelessCraftingRecipe)recipe;
        ImmutableList<ItemDefinition> inputDefinitions = shapelessCraftingRecipe.GetInputs();
        Object[] inputs = new Object[inputDefinitions.size()];
        for (int i = 0; i < inputDefinitions.size(); ++i) {
            ItemDefinition definition = (ItemDefinition)inputDefinitions.get(i);
            Item item = itemRegistry.FetchItem(definition);
            inputs[i] = item;
        }
        RecipeResult result = shapelessCraftingRecipe.GetResult();
        ItemStack resultItemStack = FmlRecipeRegistrar.GetResultItemStack(result, itemRegistry);
        GameRegistry.addShapelessRecipe((ItemStack)resultItemStack, (Object[])inputs);
    }

    private static ItemStack GetResultItemStack(RecipeResult result, ItemRegistry itemRegistry) {
        ItemDefinition resultItemDefinition = result.GetItemDefinition();
        Item resultItem = itemRegistry.FetchItem(resultItemDefinition);
        ItemStack resultItemStack = new ItemStack(resultItem);
        int requestedStackSize = Math.max(1, result.GetCount());
        resultItemStack.func_190920_e(Math.min(requestedStackSize, resultItemStack.func_77976_d()));
        return resultItemStack;
    }
}

