/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.yalsm;

import airbreather.mods.airbreathercore.item.ItemDefinition;
import airbreather.mods.airbreathercore.recipe.Recipe;
import airbreather.mods.airbreathercore.recipe.RecipeConfiguration;
import airbreather.mods.airbreathercore.recipe.RecipeResult;
import airbreather.mods.airbreathercore.recipe.ShapedCraftingRecipe;
import airbreather.mods.airbreathercore.recipe.SmeltingRecipe;
import airbreather.mods.yalsm.YalsmConstants;
import com.google.common.collect.ImmutableList;

final class YalsmRecipeConfiguration
implements RecipeConfiguration {
    private boolean enableSimpleRecipe = false;
    private boolean enablePatchworkCraftingRecipe = false;

    YalsmRecipeConfiguration() {
    }

    public void EnableSimpleSmeltingRecipe() {
        this.enableSimpleRecipe = true;
    }

    public void EnablePatchworkCraftingRecipe() {
        this.enablePatchworkCraftingRecipe = true;
    }

    @Override
    public Iterable<Recipe> GetRecipes() {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        ItemDefinition rottenFlesh = YalsmConstants.RottenFleshItemDefinition;
        ItemDefinition leather = YalsmConstants.LeatherItemDefinition;
        ItemDefinition patchwork = YalsmConstants.PatchworkItemDefinition;
        RecipeResult patchworkResult = new RecipeResult(patchwork);
        RecipeResult leatherResult = new RecipeResult(leather);
        if (this.enableSimpleRecipe) {
            float simpleSmeltingExperience = 0.1f;
            SmeltingRecipe simpleRecipe = new SmeltingRecipe(leatherResult, rottenFlesh, simpleSmeltingExperience);
            resultBuilder.add((Object)simpleRecipe);
        }
        if (this.enablePatchworkCraftingRecipe) {
            ShapedCraftingRecipe patchworkCraftingRecipe = new ShapedCraftingRecipe(patchworkResult, "# #", " # ", "# #", Character.valueOf('#'), rottenFlesh);
            resultBuilder.add((Object)patchworkCraftingRecipe);
        }
        float patchworkSmeltingExperience = 0.35f;
        SmeltingRecipe patchworkSmeltingRecipe = new SmeltingRecipe(leatherResult, patchwork, patchworkSmeltingExperience);
        resultBuilder.add((Object)patchworkSmeltingRecipe);
        return resultBuilder.build();
    }
}

