/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.yalsm;

import airbreather.mods.airbreathercore.CustomConfigurationBase;
import airbreather.mods.airbreathercore.item.ItemConfiguration;
import airbreather.mods.airbreathercore.recipe.RecipeConfiguration;
import airbreather.mods.yalsm.YalsmItemConfiguration;
import airbreather.mods.yalsm.YalsmRecipeConfiguration;
import com.google.common.base.Preconditions;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

final class YalsmConfigurationAdapter
extends CustomConfigurationBase {
    private final YalsmItemConfiguration itemConfiguration;
    private final YalsmRecipeConfiguration recipeConfiguration;

    public YalsmConfigurationAdapter(YalsmItemConfiguration itemConfiguration, YalsmRecipeConfiguration recipeConfiguration) {
        this.itemConfiguration = (YalsmItemConfiguration)Preconditions.checkNotNull((Object)itemConfiguration, (Object)"itemConfiguration");
        this.recipeConfiguration = (YalsmRecipeConfiguration)Preconditions.checkNotNull((Object)recipeConfiguration, (Object)"recipeConfiguration");
    }

    public void Initialize(File configurationFile) {
        Configuration forgeConfiguration = new Configuration(configurationFile);
        forgeConfiguration.load();
        if (YalsmConfigurationAdapter.ShouldEnableSimpleRecipe(forgeConfiguration)) {
            this.recipeConfiguration.EnableSimpleSmeltingRecipe();
        }
        if (YalsmConfigurationAdapter.ShouldEnablePatchworkCraftingRecipe(forgeConfiguration)) {
            this.recipeConfiguration.EnablePatchworkCraftingRecipe();
        }
        forgeConfiguration.save();
    }

    public RecipeConfiguration GetRecipeConfiguration() {
        return this.recipeConfiguration;
    }

    public ItemConfiguration GetItemConfiguration() {
        return this.itemConfiguration;
    }

    private static boolean ShouldEnableSimpleRecipe(Configuration forgeConfiguration) {
        boolean enableSimpleRecipeDefault = false;
        String enableSimpleRecipeName = "enableSimpleRecipe";
        String enableSimpleRecipeComment = "Enable the Rotten Flesh --> Leather smelting recipe?  true/false (false is the default)";
        Property enableSimpleRecipeProperty = forgeConfiguration.get("general", "enableSimpleRecipe", false, "Enable the Rotten Flesh --> Leather smelting recipe?  true/false (false is the default)");
        return enableSimpleRecipeProperty.getBoolean(false);
    }

    private static boolean ShouldEnablePatchworkCraftingRecipe(Configuration forgeConfiguration) {
        return true;
    }
}

