/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.api;

import com.gmail.nossr50.chat.ChatManager;
import com.gmail.nossr50.chat.ChatManagerFactory;
import com.gmail.nossr50.chat.PartyChatManager;
import com.gmail.nossr50.datatypes.chat.ChatMode;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class ChatAPI {
    private ChatAPI() {
    }

    public static void sendPartyChat(Plugin plugin, String sender, String displayName, String party, String message) {
        ChatAPI.getPartyChatManager(plugin, party).handleChat(sender, displayName, message);
    }

    public static void sendPartyChat(Plugin plugin, String sender, String party, String message) {
        ChatAPI.getPartyChatManager(plugin, party).handleChat(sender, message);
    }

    public static void sendAdminChat(Plugin plugin, String sender, String displayName, String message) {
        ChatManagerFactory.getChatManager(plugin, ChatMode.ADMIN).handleChat(sender, displayName, message);
    }

    public static void sendAdminChat(Plugin plugin, String sender, String message) {
        ChatManagerFactory.getChatManager(plugin, ChatMode.ADMIN).handleChat(sender, message);
    }

    public static boolean isUsingPartyChat(Player player) {
        return UserManager.getPlayer(player).isChatEnabled(ChatMode.PARTY);
    }

    public static boolean isUsingPartyChat(String playerName) {
        return UserManager.getPlayer(playerName).isChatEnabled(ChatMode.PARTY);
    }

    public static boolean isUsingAdminChat(Player player) {
        return UserManager.getPlayer(player).isChatEnabled(ChatMode.ADMIN);
    }

    public static boolean isUsingAdminChat(String playerName) {
        return UserManager.getPlayer(playerName).isChatEnabled(ChatMode.ADMIN);
    }

    public static void togglePartyChat(Player player) {
        UserManager.getPlayer(player).toggleChat(ChatMode.PARTY);
    }

    public static void togglePartyChat(String playerName) {
        UserManager.getPlayer(playerName).toggleChat(ChatMode.PARTY);
    }

    public static void toggleAdminChat(Player player) {
        UserManager.getPlayer(player).toggleChat(ChatMode.ADMIN);
    }

    public static void toggleAdminChat(String playerName) {
        UserManager.getPlayer(playerName).toggleChat(ChatMode.ADMIN);
    }

    private static ChatManager getPartyChatManager(Plugin plugin, String party) {
        ChatManager chatManager = ChatManagerFactory.getChatManager(plugin, ChatMode.PARTY);
        ((PartyChatManager)chatManager).setParty(PartyManager.getParty(party));
        return chatManager;
    }
}

