/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.chat;

import com.gmail.nossr50.chat.ChatManager;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.events.chat.McMMOPartyChatEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PartyChatManager
extends ChatManager {
    private Party party;

    protected PartyChatManager(Plugin plugin) {
        super(plugin, Config.getInstance().getPartyDisplayNames(), Config.getInstance().getPartyChatPrefix());
    }

    public void setParty(Party party) {
        this.party = party;
    }

    @Override
    public void handleChat(String senderName, String displayName, String message, boolean isAsync) {
        this.handleChat(new McMMOPartyChatEvent(this.plugin, senderName, displayName, this.party.getName(), message, isAsync));
    }

    @Override
    protected void sendMessage() {
        if (Config.getInstance().getPartyChatColorLeaderName() && this.senderName.equalsIgnoreCase(this.party.getLeader())) {
            this.message = this.message.replaceFirst(Pattern.quote(this.displayName), ChatColor.GOLD + Matcher.quoteReplacement(this.displayName) + ChatColor.RESET);
        }
        for (Player member : this.party.getOnlineMembers()) {
            member.sendMessage(this.message);
        }
        if (this.party.getAlly() != null) {
            for (Player member : this.party.getAlly().getOnlineMembers()) {
                String allyPrefix = LocaleLoader.formatString(Config.getInstance().getPartyChatPrefixAlly(), new Object[0]);
                member.sendMessage(allyPrefix + this.message);
            }
        }
        this.plugin.getLogger().info("[P]<" + this.party.getName() + ">" + this.message);
    }
}

